
#ifndef JOB_CONTROL_H
#define JOB_CONTROL_H

#include "common.h"
#include "ripper_encoder_manipulation.h"
#include "main_window_handler.h"
#include "select_frame_handler.h"
#include "status_frame_handler.h"

#define CLEAR_PIPE_BUF_SIZE         512
#define COUNT_BEFORE_GET_AVG        10

#define CALC_START_SESSION          0
#define CALC_STOP_SESSION           1
#define CALC_START                  2
#define CALC_UPDATE                 3
#define CALC_STOP                   4
#define CALC_PAUSE                  5
#define CALC_CONT                   6

#define JC_START                    0
#define JC_UPDATE                   1
#define JC_PAUSE                    2
#define JC_CONT                     3
#define JC_ABORT                    4
#define JC_ABORT_DELETE             5
#define JC_ABORT_ALL                6
#define JC_ABORT_ALL_DELETE         7
#define JC_TIMEOUT                  450

#define JC_T_START                  0
#define JC_T_UPDATE                 1
#define JC_T_STOP                   2


/* Statistical structure */
// duplicated in status_frame_handler.h
#ifndef _STAT_DEFINED
#define _STAT_DEFINED
typedef struct {
		int type;
		int track;
		char src_file_name[ MAX_FILE_NAME_LENGTH ];
		char dest_file_name[ MAX_FILE_NAME_LENGTH ];
		time_t total_time_elapsed;
		time_t time_elapsed;
		time_t total_time_remain;
		time_t time_remain;
		float progress;
		float total_progress;
} _stat;
#endif

/* Dialog structure */
typedef struct {
		char *title;
		char *msg;
} _dialog_data;

/* Function Prototypes */
int lock_file( char *file_name, int is_temp );
void unlock_file( char *file_name );
/* calculates statiscal info to report to the user */
void calc_stat( _main_data *main_data, _stat *stat,
                unsigned current, int cur_track, int cur_type, int ops );
// current is length_processes now

void job_starter( _main_data *main_data );
void job_finisher( _main_data *main_data );
/* This function finds what to do next. type is WAV or MP3.
 * It returns -1 when there's no job left, 0 when a job's found */
int find_next_job( _main_data *main_data,
                   int cur_track, int cur_type,
                   int *next_track, int *next_type );
/* data will be casted to int and used as ops */
int job_controller_timeout( gpointer data );
/* Job controller. This function saves main_data
 * when called with JC_START and uses it for further operation */
void job_controller( int ops, _main_data *main_data );

#endif