
#include "main.h"

/* Global variable */
_config config;
int where_now;

void ripperX_init( _main_data *main_data )
{
	memset( main_data, 0, sizeof( _main_data ) );

	read_config();

	main_window_handler( WIDGET_CREATE, 0, main_data );
	return;
}


void ripperX_exit( GtkWidget *widget, gpointer callback_data )
{
	if ( where_now == STATUS_FRAME )
	{
		job_controller( JC_PAUSE, NULL );

		/* Confirm */
		if ( dialog_handler( WIDGET_CREATE, FALSE, DL_ABORT_CONFIRM,
                 			FALSE, NULL, NULL, 0 ) == FALSE )
		{
			job_controller( JC_CONT, NULL );
			return;
		}

		/* Terminate current job */
		if ( dialog_handler( WIDGET_CREATE, FALSE, DL_DELETE_ON_ABORT,
                 			FALSE, NULL, NULL, 0 ) == TRUE )
			job_controller( JC_ABORT_ALL_DELETE, NULL );
		else
			job_controller( JC_ABORT_ALL, NULL );
	}

	/* Write configuration file */
	write_config();

	main_window_handler( WIDGET_DESTROY, NULL, NULL );

	gtk_main_quit();
}

int main( int argc, char *argv[] )
{
	_main_data main_data;

	gtk_init( &argc, &argv );

	ripperX_init( &main_data );

	gtk_main();

	return 0;
}
 