
#ifndef MAIN_WINDOW_HANDLER_H
#define MAIN_WINDOW_HANDLER_H

#include "common.h"
#include "interface_common.h"
#include "main.h"
#include "config_window_handler.h"
#include "players_manipulation.h"
#include "ripper_encoder_manipulation.h"
#include "select_frame_handler.h"
#include "job_control.h"
#include "status_frame_handler.h"
#include "cddb.h"

#define MW_MODE_SELECT              100
#define MW_MODE_STATUS              101
#define MW_MODE_CONFIG              102
#define MW_CLEAR_STATUSBAR          103
#define MW_UPDATE_STATUSBAR         104
#define MW_REQUEST_MF               105

/* Creates main window. Returns the pointer to main frame which will be
 * used by select frame and update frames. ops can be one of WIDGET_CREATE,
 * MW_MODE_SELECT, MW_MODE_STATUS, MW_MODE_CONFIG, MW_UPDATE_STATUSBAR */
void mw_config_button_clicked( GtkWidget *widget, gpointer callback_data );
void mw_stop_button_clicked( GtkWidget *widget, gpointer callback_data );
void mw_go_button_clicked( GtkWidget *widget, gpointer callback_data );
void mw_pause_button_clicked( GtkWidget *widget, gpointer callback_data );
void mw_exit_button_clicked( GtkWidget *widget, gpointer callback_data );
GtkWidget *main_window_handler( int ops, char *status_bar_msg,
                                _main_data *main_data );
/* main_data is used to install button callbacks */

#endif