
#include "misc_utils.h"

int add_argv( char **dest, char *content )
{
	size_t i;

	i = 0;

	while ( content[ i++ ] != '\0' ) ;

	if ( ( *dest = malloc( i ) ) == NULL )
	{
		err_handler( MALLOC_ERR, NULL );
		return FALSE;
	}

	strcpy( *dest, content );
	return TRUE;
}

int process_options( char *options, char **argv, int start, int end )
{
	int current, i, j, flag;
	char buf[ MAX_SINGLE_OPTION_LENGTH ];

	current = start;
	i = 0;
	while ( options[ i ] != '\0' )
	{
		while ( isspace( options[ i ] ) ) i++;
		j = 0;
		flag = 0;
		while ( !isspace( options[ i ] )
    			&& options[ i ] != '\0'
    			&& j < MAX_SINGLE_OPTION_LENGTH - 1 )
		{
			/* It really has something other than spaces */
			flag = 1;
			buf[ j++ ] = options[ i++ ];
		}
		buf[ j ] = '\0';

		/* If it really has something */
		if ( flag )
		{
			if ( current < end )
			{
				if ( add_argv( &argv[ current ], buf ) == FALSE )
					return - 1;
			}
			else
			{
				err_handler( TOO_MANY_ARGS_ERR, NULL );
			}
			current++;
		}
	}
	return current - start;
}

char **create_argv_for_execution_using_shell( char *command )
{
	char * shell;
	char **argv;

	shell = config.shell_for_execution;

	if ( ( argv = ( char ** )malloc( sizeof( char * ) * 4 ) ) == NULL )
	{
		err_handler( MALLOC_ERR, NULL );
		return NULL;
	}
	argv[ 0 ] = NULL;
	argv[ 1 ] = NULL;
	argv[ 2 ] = NULL;
	argv[ 3 ] = NULL;

	if ( add_argv( &( argv[ 0 ] ), shell ) == FALSE )
		return NULL;
	if ( add_argv( &( argv[ 1 ] ), "-c" ) == FALSE )
		return NULL;
	if ( add_argv( &( argv[ 2 ] ), command ) == FALSE )
		return NULL;
	return argv;
}

void free_argv( char **argv )
{
	int i;

	i = 0;
	while ( argv[ i ] != NULL )
		free( argv[ i++ ] );

	free( argv );
}

int parse_rx_format_string( char *target, int target_len,
                            char *format,
                            int track_no, char *w_fname, char *m_fname,
                            char *artist, char *album, char *song )
{
	int s, d, i;
	char space, ch;
	char *tmp;
	char track_no_str[ 4 ];

	track_no_str[ 0 ] = 0;
	if ( track_no >= 0 )
		snprintf( track_no_str, sizeof( track_no_str ), "%d", track_no + 1 );

	s = 0; d = 0;

	while ( format[ s ] != '\0' && d < target_len - 1 )
	{
		// determine space character and check for error
		space = ' ';
		if ( format[ s ] == '%' )
		{
			ch = format[ s + 1 ];
			if ( ch == '\0' )
			{
				return - 1;
			}
			if ( ch == '%' || ch == '#' || ch == 'w' || ch == 'm' ||
    				ch == 'a' || ch == 'v' || ch == 's' )
				s += 1;
			else
			{
				ch = format[ s + 2 ];
				if ( ch == '\0' )
				{
					return - 1;
				}
				if ( ch == '%' || ch == '#' || ch == 'w' || ch == 'm' ||
    					ch == 'a' || ch == 'v' || ch == 's' )
				{
					space = format[ s + 1 ];
					s += 2;
				}
			}

			// determine what to copy
			tmp = NULL;
			switch ( format[ s ] )
			{
				case '%' :
					tmp = "%";
					break;
				case '#' :
					tmp = track_no_str;
					break;
				case 'w' :
					tmp = w_fname;
					break;
				case 'm' :
					tmp = m_fname;
					break;
				case 'a' :
					tmp = artist;
					break;
				case 'v' :
					tmp = album;
					break;
				case 's' :
					tmp = song;
					break;
			}
			if ( tmp == NULL )
			{
				return - 1;
			}
			// expand
			for ( i = 0; tmp[ i ] != '\0'; )
				target[ d++ ] = tmp[ i++ ];
			s++;
		}
		else
			target[ d++ ] = format[ s++ ];
	}
	if ( format[ s ] != '\0' )
	{
		err_handler( RX_PARSING_ERR, "Buffer overflow" );
		return - 1;
	}

	target[ d ] = '\0';
	return 0;
}

char *time_to_readable( time_t sec )
{
	static char buf[ 10 ];

	sprintf( buf, "%2d:%02d", ( int )sec / 60, ( int )sec % 60 );
	return buf;
}

char *length_to_readable( unsigned length )
{
	time_t sec;

	sec = ( float )length / CD_SECTORS_PER_SEC;
	return time_to_readable( sec );
}


char *expand_tilde( char *path )
{
	static char buf[ MAX_FILE_PATH_LENGTH + MAX_FILE_NAME_LENGTH ];

	if ( path[ 0 ] != '~' )
		return path;
	strcpy( buf, getenv( "HOME" ) );
	strcpy( buf + strlen( buf ), path + 1 );
	return buf;
}

char *construct_file_name( char *path, char *name )
{
	int offset;
	static char buf[ MAX_FILE_PATH_LENGTH + MAX_FILE_NAME_LENGTH ];

	strcpy( buf, path );
	offset = strlen( buf ) - 1;
	if ( buf[ offset ] != '/' )
		buf[ ++offset ] = '/';

	offset++;

	strcpy( buf + offset, name );
	return buf;
}

char *file_name_without_path( char *src )
{
	int offset;

	offset = strlen( src ) - 1;

	while ( src[ offset ] != '/' && offset >= 0 )
		offset--;

	return src + ++offset;
}

char *file_path_without_name( char *src )
{
	static char buf[ MAX_FILE_PATH_LENGTH ];
	int offset;

	offset = strlen( src ) - 1;

	while ( src[ offset ] != '/' && offset >= 0 )
		offset--;

	strncpy( buf, src, offset );
	return buf;
}

void auto_append_extension( char *src, int type )
{
	int offset;

	offset = strlen( src ) - 4;
	/* aasdfasdfasd.wav */
	/*             ^    */

	if ( type == WAV )
	{
		if ( strcmp( ".wav", src + offset ) != 0 )
		{
			offset += 4;
			strcpy( src + offset, ".wav" );
			return;
		}
	}
	else
	{
		if ( strcmp( ".mp3", src + offset ) != 0 )
		{
			offset += 4;
			strcpy( src + offset, ".mp3" );
			return;
		}
	}
}
char *get_default_file_name( int type, int track )
{
	char name_format[ MAX_FILE_NAME_LENGTH ];
	char name_buf[ MAX_FILE_NAME_LENGTH ], name_buf2[ MAX_FILE_NAME_LENGTH ];
	char path_buf[ MAX_FILE_PATH_LENGTH ];
	char track_no_buf[ 5 ];
	int read_offset, write_offset, return_val;
	struct stat st;

	if ( type == WAV )
	{
		strcpy( name_format, config.wav_file_name_format );
		strcpy( path_buf, config.wav_path );
	}
	else
	{
		strcpy( name_format, config.mp3_file_name_format );
		strcpy( path_buf, config.mp3_path );
	}

	read_offset = -1;
	write_offset = 0;
	while ( name_format[ ++read_offset ] != '\0' )
	{
		if ( name_format[ read_offset ] == '%' )
		{
			snprintf( track_no_buf, 5, "%d", track + 1 );
			strcpy( name_buf + write_offset, track_no_buf );
			write_offset += strlen( track_no_buf );
		}
		else name_buf[ write_offset++ ] = name_format[ read_offset ];
	}
	name_buf[ write_offset ] = '\0';

	return_val = stat( construct_file_name( path_buf, name_buf ), &st );
	while ( ( return_val == 0 || errno != ENOENT )
    		&& strlen( name_buf ) < MAX_FILE_NAME_LENGTH - 2 )
	{
		strcpy( name_buf2, name_buf );
		name_buf[ 0 ] = config.prepend_char;
		strcpy( name_buf + 1, name_buf2 );

		return_val = stat( construct_file_name( path_buf, name_buf ), &st );
	}
	return construct_file_name( path_buf, name_buf );
}

/* This code is borrowed from telnetd source code which was in the
   inetutils-1.3.2 package from GNU */
int open_a_pty( int *pty, int *tty )
{
	char line[ 12 ];
	char *p1, *p2;
	char *cp;
	int i;

	sprintf( line, "/dev/ptyXX" );
	p1 = &line[ 8 ];
	p2 = &line[ 9 ];

	for ( cp = "pqrstuvwxyzPQRST"; *cp; cp++ )
	{
		struct stat stb;

		*p1 = *cp;
		*p2 = '0';
		/*
		 * This stat() check is just to keep us from
		 * looping through all 256 combinations if there
		 * aren't that many ptys available.
		 */
		if ( stat( line, &stb ) < 0 )
			break;
		for ( i = 0; i < 16; i++ )
		{
			*p2 = "0123456789abcdef"[ i ];
			*pty = open( line, O_RDWR );
			if ( *pty > 0 )
			{
				line[ 5 ] = 't';
				/* Now open appropriate tty */
				if ( ( *tty = open( line, O_RDWR ) ) < 0 )
				{
					line[ 5 ] = 'p';
					close( *pty );
					continue;
				}
				return 0;
			}
		}
	}
	return - 1;
}

int is_str_blank( char *str )
{
	int i;

	i = 0;
	while ( str[ i++ ] != '\0' )
		if ( !isspace( str[ i ] ) && str[ i ] != '\0' )
			return FALSE;
	return TRUE;
}

void remove_non_unix( char *src)
{
	int i;

	for (i=0; src[i] != 0; i++)
	{
		if (src[i] == '/')
			src[i] = '-';
		if (src[i] == '\"')
			src[i] = '';
		if (src[i] == '\'')
			src[i] = '';
		if (src[i] == '\\')
			src[i] = '-';
	}
}
