
#ifndef RIPPER_ENCODER_MANIPULATION_H
#define RIPPER_ENCODER_MANIPULATION_H

#include "common.h"

#define BUF_LENGTH_FOR_F_SCAN_CD    150

#define MAX_PLUGIN_OUTPUT_LENGTH    1024

// return values of read_and_process... & parse_plugin_output
#define PLUGIN_MSG_PARSE_ERR        -2
#define PLUGIN_NO_MSG_AVAILABLE     -1
#define PLUGIN_PROGRESS_MSG         0
#define PLUGIN_WARN_MSG             1
#define PLUGIN_ERR_MSG              2

char **cdparanoia_create_argv( char *file_name, int track );
/* If track is >= 0, it will return a pointer to a static pointer
 * argv which will begin the ripping. If track is less than zero
 * it will return a pointer to argv which, when used in execvp, will make
 * cdparanoia to display the contents of the cd. <<IMPORTANT>> Cdparanoia
 * is supposed to ignore unnessary options given when displaying table of
 * contents */
// now only used by scan_cd !!!
int process_cd_contents_output( _main_data *main_data, int pipe_fd );
int scan_cd( _main_data *main_data );

int start_ripping_encoding( int type, int begin, int length,
                            int track,
                            char *src_file_name, char *dest_file_name,
                            int *program_pid, int *plugin_pid,
                            int *read_fd );
// type is either WAV(rip) or MP3(encode)

int execute_ripper_encoder_with_plugin( char *pg_com,
                                        char *pi_com,
                                        int *program_pid, int *plugin_pid,
                                        int *read_fd );

int read_and_process_plugin_output( int read_fd, double *progress, char *msg );
// process one line at a time
int parse_plugin_output( char *out, double *progress, char *msg );

#endif