
#include "status_frame_handler.h"

#include "xpms/ripperX.xpm"

void time_status_frame_handler( int ops, GtkWidget *time_frame, _stat *stat )
{
	static GtkWidget * vbox = NULL, *hbox[ 4 ];
	static GtkWidget *time_elapsed_label, *time_remain_label;
	static GtkWidget *total_time_elapsed_label, *total_time_remain_label;
	GtkWidget *temp;

	switch ( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * label;

				if ( vbox != NULL )
					return;

				vbox = gtk_vbox_new( FALSE, 5 );
				gtk_container_border_width( GTK_CONTAINER( vbox ), 5 );
				gtk_container_add( GTK_CONTAINER( time_frame ), vbox );

				hbox[ 0 ] = gtk_hbox_new( FALSE, 49 );
				gtk_box_pack_start( GTK_BOX( vbox ), hbox[ 0 ], TRUE, TRUE, 0 );
				label = gtk_label_new( "Time Elapsed :" );
				gtk_box_pack_start( GTK_BOX( hbox[ 0 ] ), label, FALSE, FALSE, 0 );

				time_elapsed_label = gtk_label_new( time_to_readable( 0 ) );
				gtk_box_pack_start( GTK_BOX( hbox[ 0 ] ), time_elapsed_label,
                    				FALSE, FALSE, 0 );

				hbox[ 1 ] = gtk_hbox_new( FALSE, 18 );
				gtk_box_pack_start( GTK_BOX( vbox ), hbox[ 1 ], TRUE, TRUE, 0 );
				label = gtk_label_new( "Total Time Elapsed :" );
				gtk_box_pack_start( GTK_BOX( hbox[ 1 ] ), label, FALSE, FALSE, 0 );

				total_time_elapsed_label = gtk_label_new( time_to_readable( 0 ) );
				gtk_box_pack_start( GTK_BOX( hbox[ 1 ] ), total_time_elapsed_label,
                    				FALSE, FALSE, 0 );

				hbox[ 2 ] = gtk_hbox_new( FALSE, 36 );
				gtk_box_pack_start( GTK_BOX( vbox ), hbox[ 2 ], TRUE, TRUE, 0 );
				label = gtk_label_new( "Time Remaining :" );
				gtk_box_pack_start( GTK_BOX( hbox[ 2 ] ), label, FALSE, FALSE, 0 );

				time_remain_label = gtk_label_new( time_to_readable( 0 ) );
				gtk_box_pack_start( GTK_BOX( hbox[ 2 ] ), time_remain_label,
                    				FALSE, FALSE, 0 );

				hbox[ 3 ] = gtk_hbox_new( FALSE, 5 );
				gtk_box_pack_start( GTK_BOX( vbox ), hbox[ 3 ], TRUE, TRUE, 0 );
				label = gtk_label_new( "Total Time Remaining :" );
				gtk_box_pack_start( GTK_BOX( hbox[ 3 ] ), label, FALSE, FALSE, 0 );

				total_time_remain_label = gtk_label_new( time_to_readable( 0 ) );
				gtk_box_pack_start( GTK_BOX( hbox[ 3 ] ), total_time_remain_label,
                    				FALSE, FALSE, 0 );

				gtk_widget_show_all( vbox );
				return;
			}

		case WIDGET_UPDATE :
			temp = time_elapsed_label;
			time_elapsed_label = gtk_label_new( time_to_readable( stat->time_elapsed ) );
			gtk_widget_destroy( temp );
			gtk_box_pack_start( GTK_BOX( hbox[ 0 ] ), time_elapsed_label,
                    			FALSE, FALSE, 0 );
			gtk_widget_show( time_elapsed_label );

			gtk_widget_destroy( total_time_elapsed_label );
			total_time_elapsed_label = gtk_label_new(
                             			time_to_readable( stat->total_time_elapsed ) );
			gtk_box_pack_start( GTK_BOX( hbox[ 1 ] ), total_time_elapsed_label,
                    			FALSE, FALSE, 0 );
			gtk_widget_show( total_time_elapsed_label );

			gtk_widget_destroy( time_remain_label );
			time_remain_label = gtk_label_new( time_to_readable( stat->time_remain ) );
			gtk_box_pack_start( GTK_BOX( hbox[ 2 ] ), time_remain_label,
                    			FALSE, FALSE, 0 );
			gtk_widget_show( time_remain_label );

			gtk_widget_destroy( total_time_remain_label );
			total_time_remain_label = gtk_label_new(
                            			time_to_readable( stat->total_time_remain ) );
			gtk_box_pack_start( GTK_BOX( hbox[ 3 ] ), total_time_remain_label,
                    			FALSE, FALSE, 0 );
			gtk_widget_show( total_time_remain_label );

			return;

		case WIDGET_DESTROY :
			if ( vbox == NULL )
				return;
			gtk_widget_destroy( vbox );
			vbox = NULL;
			return;
	}
}

/* Callback data is type */

void wms_p_c_button_clicked( GtkWidget *widget, gpointer callback_data )
{
	wm_status_frame_handler( WMS_P_C_BUTTON_ACT, ( int )callback_data,
                         	NULL, NULL );
}

void wms_abort_button_clicked( GtkWidget *widget, gpointer callback_data )
{
	wm_status_frame_handler( WMS_ABORT_BUTTON_ACT, ( int )callback_data,
                         	NULL, NULL );
}

void wms_abort_all_button_clicked( GtkWidget *widget, gpointer callback_data )
{
	wm_status_frame_handler( WMS_ABORT_ALL_BUTTON_ACT, ( int )callback_data,
                         	NULL, NULL );
}

void wm_status_frame_handler( int ops, int type,
                              _stat *stat, char *graph_string )
{
	static GtkWidget * vbox = NULL, *pbar, *total_pbar;
	static GtkWidget *time_frame, *plabel, *total_plabel;
	static GtkWidget *hbox, *hbox2;
	static GtkWidget *p_c_button, *pause_label, *cont_label;
	static GtkWidget *pixmap = NULL;
	static char percentage_buf[ 10 ];
	static char graph_string_buf[ 50 ];
	static int count;
	static GdkPixmap *gdk_pixmap;
	static GdkBitmap *mask;

	switch ( ops )
	{
		case WIDGET_CREATE :
			{
				GtkWidget * main_frame, *label, *button, *temp_hbox, *separator;
				GtkStyle *style;
				GdkGC *gc;
				char buf[ MAX_FILE_NAME_LENGTH + 100 ];

				if ( vbox != NULL )
					return;

				count = WMS_TIME_UPDATE_CYCLE - 1;
				main_frame = main_window_handler( MW_REQUEST_MF, 0, NULL );

				vbox = gtk_vbox_new( FALSE, 5 );
				gtk_container_border_width( GTK_CONTAINER( vbox ), 5 );
				gtk_container_add( GTK_CONTAINER( main_frame ), vbox );
				gtk_widget_realize( vbox );

				/* Create pixmap */
				if ( pixmap == NULL )
				{
					style = gtk_widget_get_default_style();
					gc = style->black_gc;
					gdk_pixmap = gdk_pixmap_create_from_xpm_d( vbox->window, &mask,
             					&style->bg[ GTK_STATE_NORMAL ],
             					ripperX_xpm );
				}

				/* Title Row */
				if ( type == WAV )
					sprintf( buf, "Ripping track %d to %s",
         					stat->track + 1, stat->dest_file_name );
				else
					sprintf( buf, "Encoding %s to %s",
         					stat->src_file_name, stat->dest_file_name );
				label = gtk_label_new( buf );
				gtk_box_pack_start( GTK_BOX( vbox ), label, TRUE, FALSE, 0 );

				/* Second row */
				temp_hbox = gtk_hbox_new( FALSE, 320 );
				gtk_box_pack_start( GTK_BOX( vbox ), temp_hbox, TRUE, TRUE, 0 );
				label = gtk_label_new( "Progress" );
				gtk_box_pack_start( GTK_BOX( temp_hbox ), label, FALSE, FALSE, 0 );

				label = gtk_label_new( "Percentage" );
				gtk_box_pack_start( GTK_BOX( temp_hbox ), label, FALSE, FALSE, 0 );

				/* Row with progress bar and percentage */
				hbox = gtk_hbox_new( FALSE, 20 );
				gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, FALSE, 0 );

				pbar = gtk_progress_bar_new();
				gtk_box_pack_start( GTK_BOX( hbox ), pbar, FALSE, FALSE, 0 );
				gtk_widget_set_usize( pbar, 350, 22 );
				plabel = gtk_label_new( " 0%" );
				gtk_box_pack_start( GTK_BOX( hbox ), plabel, FALSE, FALSE, 0 );

				/* Row with total progress bar label */
				temp_hbox = gtk_hbox_new( FALSE, 289 );
				gtk_box_pack_start( GTK_BOX( vbox ), temp_hbox, TRUE, TRUE, 0 );
				label = gtk_label_new( "Total Progress" );
				gtk_box_pack_start( GTK_BOX( temp_hbox ), label, FALSE, FALSE, 0 );

				label = gtk_label_new( "Percentage" );
				gtk_box_pack_start( GTK_BOX( temp_hbox ), label, FALSE, FALSE, 0 );

				/* Row with total progress bar */
				hbox2 = gtk_hbox_new( FALSE, 20 );
				gtk_box_pack_start( GTK_BOX( vbox ), hbox2, TRUE, FALSE, 0 );

				total_pbar = gtk_progress_bar_new();
				gtk_box_pack_start( GTK_BOX( hbox2 ), total_pbar, FALSE, FALSE, 0 );
				gtk_widget_set_usize( total_pbar, 350, 22 );
				total_plabel = gtk_label_new( " 0%" );
				gtk_box_pack_start( GTK_BOX( hbox2 ), total_plabel, FALSE, FALSE, 0 );

				/* Row with time frame & pixmap */
				temp_hbox = gtk_hbox_new( FALSE, 10 );
				gtk_box_pack_start( GTK_BOX( vbox ), temp_hbox, TRUE, TRUE, 0 );

				time_frame = gtk_frame_new( "Time Info" );
				gtk_widget_set_usize( time_frame, 250, 0 );
				gtk_box_pack_start( GTK_BOX( temp_hbox ), time_frame, FALSE, FALSE, 0 );

				time_status_frame_handler( WIDGET_CREATE, time_frame, stat );

				/* Pixmap */
				pixmap = gtk_pixmap_new( gdk_pixmap, mask );
				gtk_box_pack_start( GTK_BOX( temp_hbox ), pixmap, TRUE, TRUE, 0 );

				/* Separator */
				separator = gtk_hseparator_new();
				gtk_widget_set_usize( separator, 0, 10 );
				gtk_box_pack_start( GTK_BOX( vbox ), separator, FALSE, FALSE, 0 );

				/* Buttons row */
				temp_hbox = gtk_hbox_new( FALSE, 0 );
				gtk_box_pack_start( GTK_BOX( vbox ), temp_hbox, TRUE, TRUE, 0 );

				/* Abort all button */
				button = gtk_button_new_with_label( "Abort All" );
				GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
				gtk_widget_set_usize( button, 80, 0 );
				gtk_signal_connect ( GTK_OBJECT ( button ), "clicked",
                     				GTK_SIGNAL_FUNC ( wms_abort_all_button_clicked ),
                     				( gpointer )type );
				gtk_box_pack_end( GTK_BOX( temp_hbox ), button, FALSE, FALSE, 0 );

				/* Abort button */
				button = gtk_button_new_with_label( "Abort" );
				GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
				gtk_widget_set_usize( button, 80, 0 );
				gtk_signal_connect ( GTK_OBJECT ( button ), "clicked",
                     				GTK_SIGNAL_FUNC ( wms_abort_button_clicked ),
                     				( gpointer )type );
				gtk_box_pack_end( GTK_BOX( temp_hbox ), button, FALSE, FALSE, 0 );

				/* Pause continue button */
				p_c_button = gtk_button_new();
				GTK_WIDGET_SET_FLAGS( p_c_button, GTK_CAN_DEFAULT );
				gtk_widget_set_usize( p_c_button, 80, 0 );
				pause_label = gtk_label_new( "Pause" );
				gtk_container_add( GTK_CONTAINER( p_c_button ), pause_label );
				gtk_signal_connect ( GTK_OBJECT ( p_c_button ), "clicked",
                     				GTK_SIGNAL_FUNC ( wms_p_c_button_clicked ),
                     				( gpointer )type );
				gtk_box_pack_end( GTK_BOX( temp_hbox ), p_c_button, FALSE, FALSE, 0 );
				gtk_widget_grab_default( p_c_button );

				cont_label = NULL;

				/* Status bar */
				if ( type == MP3 )
					main_window_handler( MW_UPDATE_STATUSBAR,
                     					"Encoding in progress...", NULL );
				else
					main_window_handler( MW_UPDATE_STATUSBAR,
                     					"Ripping started...", NULL );
				gtk_widget_show_all( vbox );
				return;
			}

		case WIDGET_UPDATE :
			gtk_progress_bar_update( GTK_PROGRESS_BAR( pbar ),
                         			stat->progress );
			gtk_progress_bar_update( GTK_PROGRESS_BAR( total_pbar ),
                         			stat->total_progress );

			if ( count++ > WMS_TIME_UPDATE_CYCLE )
			{
				snprintf( percentage_buf, sizeof( percentage_buf ),
          				"%2d%%", ( int )( stat->progress * 100 ) );
				gtk_widget_destroy( plabel );
				plabel = gtk_label_new( percentage_buf );
				gtk_box_pack_start( GTK_BOX( hbox ), plabel, FALSE, FALSE, 0 );
				gtk_widget_show( plabel );

				snprintf( percentage_buf, sizeof( percentage_buf ),
          				"%2d%%", ( int )( stat->total_progress * 100 ) );
				gtk_widget_destroy( total_plabel );
				total_plabel = gtk_label_new( percentage_buf );
				gtk_box_pack_start( GTK_BOX( hbox2 ), total_plabel, FALSE, FALSE, 0 );
				gtk_widget_show( total_plabel );

				if ( type == WAV )
				{
					snprintf( graph_string_buf, sizeof( graph_string_buf ),
          					"Cdparanoia: %s", graph_string );
					main_window_handler( MW_UPDATE_STATUSBAR, graph_string_buf, NULL );
				}

				time_status_frame_handler( WIDGET_UPDATE, time_frame, stat );
				count = 0;
			}
			return;

		case WMS_P_C_BUTTON_ACT :
			if ( pause_label != NULL )
			{
				job_controller( JC_PAUSE, NULL );

				gtk_widget_destroy( pause_label );
				pause_label = NULL;
				cont_label = gtk_label_new( "Continue" );
				gtk_container_add( GTK_CONTAINER( p_c_button ), cont_label );
				gtk_widget_show( cont_label );
			}
			else
			{
				job_controller( JC_CONT, NULL );

				gtk_widget_destroy( cont_label );
				cont_label = NULL;
				pause_label = gtk_label_new( "Pause" );
				gtk_container_add( GTK_CONTAINER( p_c_button ), pause_label );
				gtk_widget_show( pause_label );
			}
			return;

		case WMS_ABORT_BUTTON_ACT :
		case WMS_ABORT_ALL_BUTTON_ACT :

			job_controller( JC_PAUSE, NULL );

			if ( dialog_handler( WIDGET_CREATE, FALSE, DL_ABORT_CONFIRM,
                 				FALSE, NULL, NULL, 0 ) == FALSE )
			{
				job_controller( JC_CONT, NULL );
				return;
			}

			if ( dialog_handler( WIDGET_CREATE, FALSE, DL_DELETE_ON_ABORT,
                 				FALSE, NULL, NULL, 0 ) == TRUE )
			{
				if ( ops == WMS_ABORT_BUTTON_ACT )
					job_controller( JC_ABORT_DELETE, NULL );

				else
					job_controller( JC_ABORT_ALL_DELETE, NULL );
			}
			else
			{
				if ( ops == WMS_ABORT_BUTTON_ACT )
					job_controller( JC_ABORT, NULL );
				else
					job_controller( JC_ABORT_ALL, NULL );
			}
			return;

		case WIDGET_DESTROY :
			main_window_handler( MW_CLEAR_STATUSBAR, NULL , NULL );
			time_status_frame_handler( WIDGET_DESTROY, NULL, NULL );
			if ( vbox == NULL )
				return;
			gtk_widget_destroy( vbox );
			vbox = NULL;
			return;
	}
}
