
#ifndef STATUS_FRAME_HANDLER_H
#define STATUS_FRAME_HANDLER_H

#include "job_control.h"
#include "common.h"
#include "interface_common.h"
#include "main_window_handler.h"

#define WMS_P_C_BUTTON_ACT          100
#define WMS_ABORT_BUTTON_ACT        101
#define WMS_ABORT_ALL_BUTTON_ACT    102

#define WMS_TIME_UPDATE_CYCLE       5

// duplicated in job_control.h
#ifndef _STAT_DEFINED
#define _STAT_DEFINED
typedef struct {
		int type;
		int track;
		char src_file_name[ MAX_FILE_NAME_LENGTH ];
		char dest_file_name[ MAX_FILE_NAME_LENGTH ];
		time_t total_time_elapsed;
		time_t time_elapsed;
		time_t total_time_remain;
		time_t time_remain;
		float progress;
		float total_progress;
} _stat;
#endif

void time_status_frame_handler( int ops, GtkWidget *time_frame, _stat *stat );

/* Callback data will be casted to int, and will be used as type */
void wms_p_c_button_clicked( GtkWidget *widget, gpointer callback_data );
void wms_abort_button_clicked( GtkWidget *widget, gpointer callback_data );
void wms_abort_all_button_clicked( GtkWidget *widget, gpointer callback_data );
void wm_status_frame_handler( int ops, int type,
                              _stat *stat, char *graph_string );

#endif