
typedef float fsnd_fun(void *ptr);
typedef int isnd_fun(void *ptr);

typedef struct {
  fsnd_fun *snd_next_sample;
  fsnd_fun *snd_previous_sample;
  isnd_fun *snd_eof;
  void **snd_ptrs;
  int chans;
  int count;    /* numeric argument, if any */
  float *args;  /* explicit arguments passed in invocation */
  int nargs;    /* number of args */
  int *wbegs,*wends,*wcursors,*srates;
} snd_to_ufun;

typedef struct {
  int result_type;
  int op;
  int *lens;
  int *begs;
  int chans;
  float **results;
  char *xlabel;
  int peaks_ok;
  float peak_scaler;
  char *filename;
} ufun_to_snd;

typedef struct {
  int result_type;
  int len;
  ufun_to_snd **ops;
} ufun_list_to_snd;

#define SND_NO_OP 0
#define SND_REPORT_RESULTS 1
#define SND_CHANGE_RESULTS 2
#define SND_INSERT_RESULTS 3
#define SND_DELETE 4
#define SND_DISPLAY_RESULTS 5
#define SND_REGIONIFY_RESULTS 6
#define SND_CHANGE_AND_REGIONIFY_RESULTS 7
#define SND_INSERT_AND_REGIONIFY_RESULTS 8
#define SND_ADD_RESULTS 9
#define SND_ADD_AND_REGIONIFY_RESULTS 10

#define UFUN_ARRAY 0
#define UFUN_FILE 1
#define SND_UFUN_LIST 2


