/*  
 *  Graphics function remaps for use with the SVGALIB graphics library.
 *
 *  Copyright (C) 1995  Philip VanBaren
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include "freq.h"
#include "display.h"

/* 
 *  Definition of a set of graphics functions which call SVGAlib functions
 */
char *ptrFont;         /* Fonts for Linux SVGALIB */
char *ptrLabelFont;    /* Fonts for Linux SVGALIB */
int _font_width;
int _font_height;

void setup_graphics(void)
{
   _font_height=8;
   _font_width=8;
   if(!vga_hasmode(GMODE))
   {
      printf("VGA display does not support 640x480x256 mode"); \
      exit(1); 
   }
   vga_setmode(GMODE);
   gl_setcontextvga(GMODE);
   ptrFont=(char *)malloc(_font_width*_font_height*256*BYTESPERPIXEL);
   if(!ptrFont) 
   {
      printf("Unable to allocate memory for the font");
      exit(1); 
   }
   gl_expandfont(_font_width,_font_height,TEXT_COLOR,gl_font8x8,ptrFont);
   ptrLabelFont=(char *)malloc(_font_width*_font_height*256*BYTESPERPIXEL);
   if(!ptrLabelFont) 
   {
      printf("Unable to allocate memory for the font");
      exit(1); 
   }
   gl_expandfont(_font_width,_font_height,LABEL_COLOR,gl_font8x8,ptrLabelFont);
   gl_setfontcolors(0,TEXT_COLOR);
   gl_setfont(_font_width,_font_height,ptrFont); 
}

void draw_rectangle(int x1,int y1,int x2,int y2,int c)
{
   gl_hline(x1,y1,x2,c);gl_hline(x1,y2,x2,c);
   gl_line(x1,y1,x1,y2,c);gl_line(x2,y1,x2,y2,c);
}

void draw_fontcolor(int c)
{
   /* We only accept two colors here */
   if(c==TEXT_COLOR)
      gl_setfont(_font_width,_font_height,ptrFont);
   else
      gl_setfont(_font_width,_font_height,ptrLabelFont);
}

void draw_text_vertical(int x,int y,char *string)
{
   while(*string)
   {
      gl_writen(x,y,1,string);
      y+=_font_height;
      string++;
   }
}

int draw_getkey(void)
{
   int ch=vga_getkey();
   if(ch==0x1b)
   {
      /* Remap keypad keys to useful equivalents */
      ch=vga_getkey();
      if(ch==0x5b)
      {
	 switch(vga_getkey())
	 {
	  case 'A': ch=UP_ARROW;    break;
	  case 'B': ch=DOWN_ARROW;  break;
	  case 'C': ch=RIGHT_ARROW; break;
	  case 'D': ch=LEFT_ARROW;  break;
	  case '1': ch=HOME;  vga_getkey(); break;
	  case '4': ch=END;   vga_getkey(); break;
	  case '5': ch=PG_UP; vga_getkey(); break;
	  case '6': ch=PG_DN; vga_getkey(); break;
	 }
      }
   }
   return ch;
}

