/* SBIO.H  */
/* Copyright 1995 by Ethan Brodsky.  All rights reserved */
/* Modified extensively by Philip VanBaren to suit my purposes */
/* Ethan Brodsky's original SB16 sampling code may be found at: */
/*    ftp://oak.oakland.edu/simtel/msdos/sound/sb16snd.zip */

typedef enum {input, output} mode;

/* Low level I/O functions */
void write_dsp(unsigned char value);
unsigned char read_dsp(void);
int reset_dsp(void);

/* Interface procedures and functions */
int init_sb(int baseio,char irq,char dma16, mode io,unsigned int length);
void shutdown_sb(void);
void startio(unsigned int rate,unsigned long length);
void stopio(void);

/* Mixer functions */
void set_cd_level(unsigned int);
void set_mic_level(unsigned int);
void set_line_level(unsigned int);
unsigned int get_cd_level(void);
unsigned int get_mic_level(void);
unsigned int get_line_level(void);

extern volatile int  sb16dmarunning;
extern volatile char curblock;
extern int far *dmaptr;   /* Pointer to beginning of DMA buffer */

