/*
 *  DireShow 0.4
 *  written by Stelios Xanthakis <axanth@tee.gr>
 *  
 *  Distribute under the terms or GNU GPL
 *     see the README for more
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include "graph.h"
#include "globdef.h"

int BuffersSize;
int shmid;
void *buffer [4];
int CurrentBuffer = 0;
int done = 1;
int NLog = 44;
float DecRatio;

extern void ipc_init (int [4], int);
extern void ipc_waitsem ();

void (*Graph) (short int*, short int*, short int*);

void main (int argc, char **argv)
{
	int k [4];
	int i;
	char ShowType;
	//
	//  Crap Option Parser II
	//
	BuffersSize = atoi (*(argv + 1));
	for (i = 0; i < 4; i++)
		k [i] = atoi (*(argv + i + 2));
	ipc_init (k, atoi (*(argv + 6)));
	ShowType = **(argv + 7);
	NLog = atoi (*(argv + 8));
	DecRatio = atoi (*(argv + 9)) / 10.0;
printf ("%i %f\n", NLog, DecRatio);
	//
	//
	printf("IPC INITIALIZATION COMPLETE\n");
	init_graph ();
	switch (ShowType)
	{
		case '1':
			Graph = drawTD;
			break;
		case '2':
			initLinearFour ();
			Graph = drawFreq;
			break;
		case '3':
			initLogFour ();
			Graph = drawLogFreq;
			break;
		case '4':
		default:
			initLogFourLong ();
			Graph = drawLogFreqLonger;
			break;
	}
	sleep (1);
	while (done)
	{
		ipc_waitsem ();
		CurrentBuffer=PPO(CurrentBuffer);
		Graph (buffer [PMO(CurrentBuffer)], buffer [CurrentBuffer],
			buffer [PPO(CurrentBuffer)]);
	}
	close_graph ();
}
