/*
 *  DireShow 0.4
 *  written by Stelios Xanthakis <axanth@tee.gr>
 *  
 *  Distribute under the terms or GNU GPL
 *     see the README for more
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <fcntl.h>

static int dsp_fd;
static int abuf_size = 0;

//
//  Setup the soundcard at: stereo, 16bit, 44100Hz
//  
int SetupSoundcard ()
{
	int tmp;
	
	dsp_fd = open ("/dev/dsp", O_WRONLY);
	if (dsp_fd == -1)
	{
		perror ("/dev/dsp:");
		exit (1);
	}
	
	ioctl (dsp_fd, SNDCTL_DSP_RESET, 0);
	ioctl (dsp_fd, SNDCTL_DSP_GETBLKSIZE, &abuf_size);
	
	if (abuf_size < 4 || abuf_size > 65535)
	{
		fprintf (stderr, "Invalid audio buffer size\n");
		exit (1);
	}
	
	if (ioctl (dsp_fd, SNDCTL_DSP_SYNC, NULL) < 0)
	{
		fprintf (stderr, "Unable to sync dsp\n");
		exit (1);
	}
	
	tmp = 16;
	ioctl (dsp_fd, SNDCTL_DSP_SAMPLESIZE, &tmp);
	
	tmp = 1;
	ioctl (dsp_fd, SNDCTL_DSP_STEREO, &tmp);

	tmp = 44100;
	ioctl (dsp_fd, SNDCTL_DSP_SPEED, &tmp);
	
	return 0;
}

//
//  Get raw data. Fairly easy
//
int GetRaw (long *buffer, int n)
{
	return read (fileno (stdin), buffer, n);
}

//
//  If soundcard is setup corerctly then a 
//   simple write () will do the job
//
void AudioWrite (long *buffer, int n)
{
	write (dsp_fd, buffer, n);
}
