/*
 *  DireShow 0.4
 *  written by Stelios Xanthakis <axanth@tee.gr>
 *  
 *  Distribute under the terms or GNU GPL
 *     see the README for more
 */
 
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include "semctrl.h"
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include "globdef.h"

#define KEY1 4321
#define KEY2 4322
#define KEY3 4323
#define KEY4 4334
#define KEY5 4335
#define KKEY1 "4321"
#define KKEY2 "4322"
#define KKEY3 "4323"
#define KKEY4 "4334"
#define KKEY5 "4335"

extern int SetupSoundcard ();
extern int GetRaw (char*, int);
extern void AudioWrite (char*, int);

int BuffersSize = 256;
int shmid [4];
int semid;
int CurrentBuffer;
void *buffer [4];
int k [4] = { KEY1, KEY2, KEY3, KEY4 };
pid_t kido;
char *argvv;
int NLog, Ratio;

//
//  Fork out the drawing process.
//  Pass to it: IPC keys, BuffersSize, type of effect
//
void forkEqualizer ()
{
	char NLogStr [10];
	char RatioStr [10];
	char BfsStr [10];
	sprintf (NLogStr, "%i", NLog);
	sprintf (RatioStr, "%i", Ratio);
	sprintf (BfsStr, "%i", BuffersSize);
	switch (kido = fork ())
	{
		case -1:
			perror ("fork:");
			exit (1);
		case 0:
			execlp ("Equalizer", "Equalizer", BfsStr, 
				KKEY1, KKEY2, KKEY3, KKEY4, KKEY5, argvv, 
				NLogStr, RatioStr, 0);
			perror ("execlp:");
			exit (1);
	}

}

//
//  Create IPC shared mem & semaphores
//
void init ()
{
	int i;
	forkEqualizer ();
	for (i = 0; i < 4; i++)
	{
		shmid [i] = shmget ((key_t) k [i], BuffersSize, 0666 | IPC_CREAT);
		if (shmid [i] == -1)
		{
			fprintf (stderr, "shmget failuer\n");
			exit (1);
		}
		buffer [i] = shmat (shmid [i], NULL, 0);
		if (buffer [i] == (void *)-1)
		{
			perror ("shmat:");
			exit (1);
		}
	}

	semid = semget (KEY5, 1, 0666 | IPC_CREAT);
	if (semid == -1)
	{
		perror ("semget:");
		exit (1);
	}
	init_sem (semid);
}

//
//  Release IPC stuff
//
void terminate ()
{
	del_sem (semid);
	shmctl (shmid [0], IPC_RMID, 0);
	shmctl (shmid [1], IPC_RMID, 0);
	shmctl (shmid [2], IPC_RMID, 0);
	shmctl (shmid [3], IPC_RMID, 0);
	kill (kido, SIGTERM);
}

void main (int argc, char **argv)
{
	int i;
	//
	//  Crap Option parser
	//
	BuffersSize = (**(argv + 1) == '1') ? 256 : 512;
	if (argc >= 3)
		BuffersSize = (**(argv+2) == 's') ? 256 : 
			      (**(argv+2) == 'v') ? 128 :512;
	NLog = 14;
	if (argc >= 4)
		NLog = atoi (*(argv+3));
	Ratio = 5;
	if (argc >= 5)
		Ratio = atoi (*(argv+4));
	argvv = *(argv + 1);
	// ok
	init ();
	free_sem (semid);
	SetupSoundcard ();
	printf ("OK\n");
	i = GetRaw (buffer [0], BuffersSize);
	i = GetRaw (buffer [1], BuffersSize);
	i = GetRaw (buffer [2], BuffersSize);
	AudioWrite (buffer [0], i);
	printf ("Init %i\n", i);
	CurrentBuffer = 3;
	do {
		lock_sem (semid);
		i = GetRaw (buffer [CurrentBuffer], BuffersSize);
//		printf ("writting to %i %i\n", PPO(CurrentBuffer), PMO(CurrentBuffer));
		free_sem (semid);
		CurrentBuffer = PPO(CurrentBuffer);
		AudioWrite (buffer [PPO(CurrentBuffer)], i);
	} while (i == BuffersSize);
	terminate ();
}
