/*
 *  DireShow 0.4
 *  written by Stelios Xanthakis <axanth@tee.gr>
 *  
 *  Distribute under the terms or GNU GPL
 *     see the README for more
 */

#include <stdio.h>
#include <math.h>
#include <vga.h>
#include <vgagl.h>

extern int BuffersSize;
extern int NLog;
extern float DecRatio;

extern unsigned char *VideoOffset;

#ifdef INTEGER_SINCOS
 int cosarr [820];
 int sinarr [820];
#else
 float cosarr [820];
 float sinarr [820];
#endif
int LogFix [820];
float Freq [50];

float denom;
int Freqs, Tims, SPB;

//
// Initialization of fast cos-sin array
//
void initFour ()
{
	float i;
	int j;	
	SPB = BuffersSize/4;
	Tims = 3*SPB;
	Freqs = Tims/2;
	for (j = 0,i = 0; i < 3*BuffersSize/4; i+=1, j++)
	{
#ifdef INTEGER_SINCOS
		sinarr [j] = rint (25000.0 * sin (8 * M_PI * i/(3*BuffersSize)));
		cosarr [j] = rint (25000.0 * cos (8 * M_PI * i/(3*BuffersSize)));
#else
		sinarr [j] = sin (8 * M_PI * i/(3*BuffersSize));
		cosarr [j] = cos (8 * M_PI * i/(3*BuffersSize));
#endif
	}


}

//
//  Creation of linear-Log array
//
void FixKatofl ()
{
	float a, b;
	float S1, S2;
	int i, n;
	a = pow (11025/180, 1.0/NLog);
	for (i = 0; i < 3*BuffersSize/8; i++)
	{
		b = i*22050*2/(BuffersSize*3);
		S1 = 0;
		S2 = 180;
		for (n = 0; n < NLog; n++)
		{
			if (b > S1 && b < S2)
			{
				LogFix [i] = n;
				break;
			}
			S1 = S2;
			S2 *= a;
		}
	}
//for (i=0;i<3*BuffersSize/8;i++)
//printf ("%i   ", LogFix [i]);
}

//
// --------------------- Show-specific init routines ----------------
//
void initTD ()
{
}
void initLinearFour ()
{
	int j;
	initFour ();
	for (j=1;j<256;j++)
		vga_setpalette (j, 64-(j/2), 1+j%2, 1+j%2);
	for (j=127; j<256;j++)
		vga_setpalette (j, 1, 1, 1);
}
void initLogFour ()
{
	int j;
	initFour ();
	for (j=1;j<256;j++)
		vga_setpalette (j, 64-(j/2), 1+j%2, 1+j%2);
	for (j=127; j<256;j++)
		vga_setpalette (j, 1, 1, 1);
	FixKatofl ();
	denom = 1000 * DecRatio * BuffersSize;
	denom /= NLog;
}
void initLogFourLong ()
{
	int j;
	initFour ();
	for (j=1;j<256;j++)
		vga_setpalette (j, 1+j%2, 1+j%2,64-(j/2));
	for (j=127; j<256;j++)
		vga_setpalette (j, 1, 1, 1);
	vga_setpalette (2, 0, 0, 30);
	FixKatofl ();
	denom = 1000 * DecRatio * BuffersSize;
	denom /= NLog;
}

//
//------------------------ DRAWING STUFF -----------------------------
//
//  Normally fourier calculating and drawing should be seperate
//   functions and files. They are one for faster result (not much
//   but even less will do)
//

//
//  Calculate fourier and draw each harmonic after
//   calculation.
//
void drawFreq (short int *p1, short int*p2, short int *p3)
{
	float I, Q;
	int l, i, f, t;
	short int *p;
	unsigned char *vmem;
	float ff;
	int y1, y2;
	for (f = 1; f < Freqs; f++) //*opt
	{
		l = t = I = Q = 0;
		for (p = p1; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
		for (l = 0,p = p2; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
		for (l = 0,p = p3; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
#ifdef INTEGER_SINCOS
		I/=25000; Q/=25000;
#endif
		ff = sqrt (I*I + Q*Q) / (13.0*BuffersSize);
		y2 = ceil (ff);
		if (y2 > 160) y2 = 160;
		y2 = 200 - y2;
		//
		//  Draw
		//
		vmem = VideoOffset + f + 320*40;
		for (y1 = 40; y1 < y2; y1 ++, vmem += 320)
			*vmem = 0;
		for (y1 = y2; y1 < 200; y1++, vmem += 320)
			*vmem = 200-y1;
	}
	vga_waitretrace ();
}

//
//  Calc all hamonics and do Log
//  Draw at the end.
//
void drawLogFreq (short int *p1, short int*p2, short int *p3)
{
	float I, Q;
	int l, i, f, t;
	short int *p;
	unsigned char *vmem;
	float ff;
	int y1, y2;
	for (f = 0; f < NLog; f++)
		Freq [f] = 0;
	for (f = 1; f < Freqs; f++)
	{
		l = t = I = Q = 0;
		for (p = p1; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
		for (l = 0,p = p2; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
		for (l = 0,p = p3; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
#ifdef INTEGER_SINCOS
		I/=25000; Q/=25000;
#endif
		ff = sqrt (I*I + Q*Q);
		Freq [LogFix [f]] += ff;
	}
	//
	//  Draw
	//
	for (f = 1; f < NLog; f++)
	{
		ff = Freq [f] / denom;
		y2 = ceil (ff);
		if (y2 > 160) y2 = 160;
		y2 = 200 - y2;
		vmem = VideoOffset + f*3 + 320*40;
		for (y1 = 40; y1 < y2; y1 ++, vmem += 319)
		{
			*vmem++ = 0;
			*vmem = 0;
		}
		for (y1 = y2; y1 < 200; y1++, vmem += 319)
		{
			*vmem++ = 200-y1;
			*vmem = 200-y1;
		}
	}
	vga_waitretrace ();
}

//
//  Draw ultra-psycho-cool-super-paranoid digital display
//
void drawLogFreqLonger (short int *p1, short int*p2, short int *p3)
{
	double I, Q;
	int l, i, f, t;
	short int *p;
	unsigned char *vmem;
	float ff;
	int y1, y2;
	for (f = 0; f < NLog; f++)
		Freq [f] = 0;
	for (f = 1; f < Freqs; f++)
	{
		l = t = I = Q = 0;
		for (p = p1; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
		for (l = 0,p = p2; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
		for (l = 0,p = p3; l < SPB; l++,t++, p+=2)
		{
			i = (t*f)%Tims;
			I += *p * sinarr [i];
			Q += *p * cosarr [i];
		}
#ifdef INTEGER_SINCOS
		I/=25000; Q/=25000;
#endif
		ff = sqrt (I*I + Q*Q);
		Freq [LogFix [f]] += ff;
	}
	//
	//  Draw
	//
	for (f = 1; f < NLog; f++)
	{
		ff = Freq [f]/denom;
		y2 = ceil (ff);
		if (y2 > 160) y2 = 160;
		y2 = 196 - y2;
		vmem = VideoOffset + f*7;
		for (y1 = 0; y1 < y2; y1 ++, vmem += 315)
		{
			*vmem++ = 0;
			*vmem++ = 0;
			*vmem++ = 0;
			*vmem++ = 0;
			*vmem++ = 0;
			*vmem = 0;
		}
		for (y1 = y2; y1 < 200; y1++, vmem += 315)
		{
			if (y1 & 1)
			{
				t = (200-y1)/2;
				*vmem++ = t;
				*vmem++ = t;
				*vmem++ = t;
				*vmem++ = t;
				*vmem++ = t;
				*vmem = t;
			}
			else vmem += 5;
		}
	}
	vga_waitretrace ();
}

//
//  Time Domain stuff
//
void drawTD (short int *p1, short int*p2, short int *p3)
{
	static int T = 64;
	int i, l, t;
	int y1, y2, y3;
	unsigned char *vmem;
	short int *p;
	int j = BuffersSize / 4;
	short int k = 512;
//	T++;
//	T %= 64;
	for (l = 0, i = 48, p = p1; l < j; l++,i++, p+=2)
	{
		y1 = 100 - *p / k;
		if (y1 > 100)
		{
			y2 = 100 - *p/(2*k);
			y1 = 100 + *p/k;
		}
		else y2 = 100 + *p/(2*k);
		vmem = VideoOffset + i;
		for (y3 = 0; y3 < y1; y3++, vmem += 320)
			*vmem = 0;
		t = (i%48)+T+48;
		for (y3 = y1; y3 < 100; y3++, vmem+= 320)
			*vmem = 228-y3;
		t += 96;
		for (y3 = 100; y3 < y2; y3++, vmem+= 320)
			*vmem = y3+124;
		for (y3 = y2; y3 < 150; y3++, vmem+=320)
			*vmem = 0;
	}
	for (l = 0, p = p2; l < j; i++, p+=2, l++)
	{
		y1 = 100 - *p / k;
		if (y1 > 100)
		{
			y2 = 100 - *p /(2*k);
			y1 = 100+ *p/k;
		}
		else y2 = 100+ *p/(2*k);
		vmem = VideoOffset + i;
		for (y3 = 0; y3 < y1; y3++, vmem += 320)
			*vmem = 0;
		t = (i%48)+T+48;
		for (y3 = y1; y3 < 100; y3++, vmem+= 320)
			*vmem = 228-y3;
		t += 96;
		for (y3 = 100; y3 < y2; y3++, vmem+= 320)
			*vmem = y3+124;
		for (y3 = y2; y3 < 150; y3++, vmem+=320)
			*vmem = 0;
	}
	for (l = 0, p = p3; l < j; i++, p+=2, l++)
	{
		y1 = 100 - *p / k;
		if (y1 > 100)
		{
			y2 = 100 - *p/(2*k);
			y1 = 100+ *p/k;
		}
		else y2 = 100 +*p/(2*k);
		vmem = VideoOffset + i;
		for (y3 = 0; y3 < y1; y3++, vmem += 320)
			*vmem = 0;
		t = (i%48)+T+48;
		for (y3 = y1; y3 < 100; y3++, vmem+= 320)
			*vmem = 228-y3;
		t += 96;
		for (y3 = 100; y3 < y2; y3++, vmem+= 320)
			*vmem = y3+124;
		for (y3 = y2; y3 < 150; y3++, vmem+=320)
			*vmem = 0;
	}
	vga_waitretrace ();
}

