/*
 *  DireShow 0.4
 *  written by Stelios Xanthakis <axanth@tee.gr>
 *  
 *  Distribute under the terms or GNU GPL
 *     see the README for more
 */

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include "semctrl.h"

extern int BuffersSize;
int shmid [4];
int semid;
extern void *buffer [4];

//
//  Create 4 shared memory segments and one
//   semaphore by the given keys.
//
void ipc_init (key_t k [4], key_t k4)
{
	int i;
	for (i = 0; i < 4; i++)
	{
		shmid [i] = shmget (k [i], BuffersSize, 0666 | IPC_CREAT);
		if (shmid [i] == -1)
		{
			perror ("i shmget:");
			printf ("%i %i %i\n", i, k[i], BuffersSize);
			exit (1);
		}
		buffer [i] = shmat (shmid [i], NULL, 0);
		if (buffer [i] == (void *)-1)
		{
			perror ("i shmat:");
			exit (1);
		}
	}

	semid = semget (k4, 0, 0666);
	if (semid == -1)
	{
		perror ("i semget:");
		exit (1);
	}
	printf ("DONA\n");
}

//
//  Try to lock --> wait until unlocked
//   then unlock
//  FYI: svgalib takes signals under its control
//   so eventhough signals might be a better
//   way to syncronize we do it with semaphores
//
void ipc_waitsem ()
{
	extern void sem_lock (int);

	lock_sem (semid);
	free_sem (semid);
}
