/*
 *  DireShow 0.4
 *  written by Stelios Xanthakis <axanth@tee.gr>
 *  
 *  Distribute under the terms or GNU GPL
 *     see the README for more
 */

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

//
//  Attempt to lock semaphore.
//  If already locked wait until the other
//    process unlocks it.
//
void lock_sem (int semid)
{
	struct sembuf sem_lock = { 0, -1, SEM_UNDO };	
	
	if (semop (semid, &sem_lock, 1) == -1)
	{
		perror ("locking semahpore:");
		exit (1);
	}
}

//
//  Unlock semaphore
//
void free_sem (int semid)
{
	struct sembuf sem_lock = { 0, 1, SEM_UNDO };	
	
	if (semop (semid, &sem_lock, 1) == -1)
	{
		perror ("unlocking semahpore:");
		exit (1);
	}
}

//
// Inital value of semaphore == 1
//  FYI: one lock will lock
//
void init_sem (int semid)
{
	union semun sem_union;
	
	sem_union.val = 0;
	if (semctl (semid, 0, SETVAL, sem_union) == -1)
	{
		perror ("Cant initialize semaphore:");
		exit (1);
	}
}

//
//  Delete the semaphore, semaphores take up resources
//   and there may be trouble next time we execute.
//
void del_sem (int semid)
{
	union semun sem_union;
	
	if (semctl (semid, 0, IPC_RMID, sem_union) == -1)
	{
		perror ("Cant delete semaphore:");
		exit (1);
	}
}
