/*
**  The JAZZ++ Midi Sequencer
**
** Copyright (C) 1994-2000 Andreas Voss and Per Sigmond, all rights reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/                                                                              

#ifndef ALSAPLAY
#define ALSAPLAY

#include "player.h"
#include "alsathru.h"

#include <sys/asoundlib.h>


// set this to 1 for latest alsa drivers to bypass queuing of midi thru events
#define USE_DIRECT 1

// use new purge IOCTL
#define USE_PURGE 1


class tAlsaDeviceList : public tDeviceList
{
public:
  int add(const char *name, const snd_seq_addr_t &a);
  snd_seq_addr_t& operator[](int i);
  void print(const char *msg);
private:
  snd_seq_addr_t addr[MAXDEVS];
};



class tAlsaPlayer : public tPlayer
{
  friend class tAlsaThru;
  public:
    tAlsaPlayer(tSong *song);
    virtual ~tAlsaPlayer();

    int Installed();
    int  OutEvent(tEvent *e, int now);
    int  OutEvent(tEvent *e) { OutEvent(e, 0); return 0; }
    void OutNow(tEvent *e)   { OutEvent(e, 1); }
    void OutNow(tParam *r);
    void OutBreak();
    void OutBreak(long BreakOver);
    void StartPlay(long Clock, long LoopClock = 0, int Continue = 0);
    void StopPlay();
    long GetRealTimeClock();
    virtual void SetSoftThru(int on, int idev, int odev);
    virtual int SupportsMultipleDevices() { return 1; }
    virtual tDeviceList & GetOutputDevices() { return oaddr; }
    virtual tDeviceList & GetInputDevices() { return iaddr; }
    virtual int GetThruInputDevice() { return ithru; }
    virtual int GetThruOutputDevice() { return othru; }

  protected:
    snd_seq_t *handle;
    tAlsaDeviceList iaddr;        // addresses of input devices
    tAlsaDeviceList oaddr;        // addresses of output devices
    int client;            // me
    snd_seq_addr_t iself;  // my input address
    snd_seq_addr_t oself;  // my output address
    snd_seq_addr_t ibcast; // broadcast to all input devices
    snd_seq_addr_t obcast; // broadcast to all output devices
 
    int installed;

    static int create_port(snd_seq_t *handle, const char *name);
    static void set_client_info(snd_seq_t *handle, const char *name);
    void subscribe_inp();
    void subscribe_out();
    void scan_clients(tAlsaDeviceList &list, int device_caps);
    int  start_timer(long clock);
    int write(snd_seq_event_t *ev) { return write(ev, 0); } // 0 == ok
    int write(snd_seq_event_t *ev, int now); // 0 == ok
    void set_event_header(snd_seq_event_t *ev, int device, long clock, int chan, int type);
    void set_event_header(snd_seq_event_t *ev, int device, long clock, int chan, int len, void *ptr);
    void set_timer_event_header(snd_seq_event_t *ev, snd_seq_addr_t &addr, long clock, int type);
    void init_queue_tempo(int queue, int time_base, int bpm);
    void start_queue_timer(snd_seq_addr_t &addr, long clock);
    void stop_queue_timer(snd_seq_addr_t &addr, long clock);
    void recd_event(snd_seq_event_t *ev);
    void flush_output();
    int  set_blocking_mode(int enable);
    void clear_input_queue();
    void purge_queues();
    void set_pool_sizes();

    long recd_clock;  // clock received so far from recorded events or echo events
    long echo_clock;  // echo events have been sent up to this clock
    long start_clock; // clock of start play position

    tAlsaThru *thru;
    int ithru, othru;  // index in iaddr, oaddr of source/target device
};


#endif

