/*
**  The JAZZ++ Midi Sequencer
**
** Copyright (C) 1994-2000 Andreas Voss and Per Sigmond, all rights reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/                                                                              


#ifndef alsathru_h
#define alsathru_h

#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <sys/asoundlib.h>
#include <unistd.h>


// does not work together with wxwin $%!
// #include <pthread.h>

class tAlsaThru
{
  public:
    tAlsaThru();
    virtual ~tAlsaThru();

    void SetSource(int client, int port) {
      source_client = client;
      source_port   = port;
    }
    void SetDestin(int client, int port) {
      destin_client = client;
      destin_port   = port;
    }
    void GetSource(int &client, int &port) {
      client = source_client;
      port   = source_port;
    }
    void GetDestin(int &client, int &port) {
      client = destin_client;
      port   = destin_port;
    }
    void Start();
    void Stop();
    int  IsRunning() const {
      return running;
    }

  private:
    int source_client;
    int source_port;
    int destin_client;
    int destin_port;

    snd_seq_t *handle;

    typedef struct {
      snd_seq_addr_t source;
      snd_seq_addr_t destin;
    } connection_t;

    connection_t inp;
    connection_t out;
    void connect(connection_t *con, int source_client, int source_port, int destin_client, int destin_port);
    void initialize();
    void loop();
    void midithru();
    static void * startworker(void *p);
    static void stopworker(int signum);

    // pthread_t worker;
    pid_t worker;
    int running;
};

#endif

