/*
**  The JAZZ++ Midi Sequencer
**
** Copyright (C) 1994-2000 Andreas Voss and Per Sigmond, all rights reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/                                                                              

#ifndef audiodrv_h
#define audiodrv_h
#include "config.h"
#ifdef AUDIO

#include <sys/soundcard.h>
// in oss/free (from kernel 2.0.29) the following is not implemented
// but this works for oss/linux for 2.0.29
// #ifndef SNDCTL_SEQ_GETTIME
// #define SNDCTL_SEQ_GETTIME		_IOR ('Q',19, int)
// #endif

#include <sys/time.h>
#include "events.h"
#include "player.h"
#include "audio.h"


class tSample;

class tAudioPlayer : public tSeq2Player
{
  friend class tAudioListener;
  public:
    tAudioPlayer(tSong *song);
    virtual ~tAudioPlayer();
    int LoadSamples(const char *filename);
    virtual void Notify();
    virtual void StartPlay(long Clock, long LoopClock = 0, int Continue = 0);
    virtual void StopPlay();
    virtual void StartAudio();
    virtual int Installed() { return installed && tSeq2Player::Installed(); }
    virtual int GetAudioEnabled() const { return audio_enabled; }
    virtual void SetAudioEnabled(int x) { audio_enabled = x; }
    virtual void ListenAudio(int key, int start_stop_mode = 1);
    virtual void ListenAudio(tSample &spl, long fr_smpl, long to_smpl);
    virtual Bool IsListening() const {
      return listener != 0;
    }
    virtual long GetListenerPlayPosition();

    // for recording
    int RecordMode() const;
    int PlaybackMode() const {
      return !RecordMode() || can_duplex;
    }

  private:
    int can_duplex;	// TRUE = can do full duplex record/play

    int WriteSamples();
    void ReadSamples();
    void MidiSync();
    void OpenDsp();
    void CloseDsp(int reset);

    int dev;
    int installed;

    long midi_clock;
    long audio_bytes;
    int  midi_speed;  // start speed in bpm
    int  curr_speed;  // actual speed in bpm
    int  audio_enabled; // 0 means midi only

    tAudioListener *listener;
    tAudioRecordBuffer recbuffers;

    int force_read;	// needed by buggy audio driver ...
};


#endif // AUDIO

#endif
