/*
**  The JAZZ++ Midi Sequencer
**
** Copyright (C) 1994-2000 Andreas Voss and Per Sigmond, all rights reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/                                                                              

#ifndef config_h
#define config_h

// not sure, if any of these #defines still work ...

// define this, if your computer is a 386 or so. It will reduce
// screenpaints
// #define SLOW_MACHINE


// define one or both of the following drivers
// note that you have to select the driver in your .jazz file too.

// support /dev/sequencer2
#define DEV_SEQUENCER2

// support DSP audio (needs DEV_SEQUENCER too)
#define AUDIO

// support jazz's own driver over tcp/ip
#define DEV_MPU401

#define DEV_ALSA

// in ms-windows, we have nothing
#ifdef wx_msw
#undef DEV_SEQUENCER2
#undef DEV_MPU401
#endif

#endif // config_h

