/*
**  The JAZZ++ Midi Sequencer
**
** Copyright (C) 1994-2000 Andreas Voss and Per Sigmond, all rights reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/                                                                              

#include "wx.h"
#pragma hdrstop

#include "mascfile.h"

// ********************************************************************************************
// Ascii-Output (debug)
// ********************************************************************************************


int tAsciiWrite::Open(char *fname, int nTracks, int TicksPerQuarter)
{
  if (!tWriteBase::Open(fname, nTracks, TicksPerQuarter))
    return 0;
  fprintf(fd, "Tracks %d, TicksPerQuarter %d\n", nTracks, TicksPerQuarter);
  return nTracks;
}

int tAsciiWrite::Write(tEvent *e, uchar *s, int len)
{
  tChannelEvent *ce;

  fprintf(fd, "%6ld %02x ",  e->Clock, e->Stat);
  if ((ce = e->IsChannelEvent()) != 0)
    fprintf(fd, "%2d ",  ce->Channel);
  else
    fprintf(fd, "-1 ");

  fprintf(fd, "%d ", len);
  for (int i = 0; i < len; i++)
    fprintf(fd, "%02x ", s[i]);
  fprintf(fd, "\n");
  return 0;
}

void tAsciiWrite::NextTrack()
{
  fprintf(fd, "NextTrack\n");
}


int tAsciiRead::Open(char *fname)
{
  int nTracks, TicksPerQuarter;
  if (fscanf(fd, "Tracks %d, TicksPerQuarter %d\n", &nTracks, &TicksPerQuarter) != 2)
    return 0;
  return nTracks;
}

tEvent *tAsciiRead::Read()
{
  long clk;
  int   sta, cha, len;

  if (fscanf(fd, "%6lu %02x %2d %d ", &clk, &sta, &cha, &len) != 4)
    return 0;

  uchar buf[len];
  for (int i = 0; i < len; i++)
  {
    int d;
    fscanf(fd, "%02x ", &d);
    buf[i] = (uchar)d;
  }

  switch (sta)
  {
    case StatUnknown:
      return 0;

    case StatKeyOff:
      return new tKeyOff(clk, cha, buf[0]);

    case StatKeyOn:
      return new tKeyOn(clk, cha, buf[0], buf[1]);

    case StatControl:
      return new tControl(clk, cha, buf[0], buf[1]);

    case StatPitch:
      return new tPitch(clk, cha, buf[0], buf[1]);

    case StatProgram:
      return new tProgram(clk, cha, buf[0]);

    case StatText:
      return new tText(clk, buf, len);

    case StatTrackName:
      return new tTrackName(clk, buf, len);

    case StatMarker:
      return new tMarker(clk, buf, len);

    case StatEndOfTrack:
      return 0;

    case StatSetTempo:
      return new tSetTempo(clk, buf[0], buf[1], buf[2]);

    case StatTimeSignat:
      return new tTimeSignat(clk, buf[0], buf[1], buf[2], buf[3]);

    case StatSysEx:
      return new tSysEx(clk, buf, len);
  }
  return 0;
}


int tAsciiRead::NextTrack()
{
  return fscanf(fd, "NextTrack\n") == 0;
}

