/*
 * simulates the jazz algorithm of midi thru
 */

#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <signal.h>


#define dprintf(a) printf a


#define SEQUENCER_DEVICE "/dev/music"

SEQ_USE_EXTBUF();
void seqbuf_dump(void);


SEQ_DEFINEBUF (8192);

int seqfd   = -1;
int mididev = -1;

void seqbuf_dump(void)
{
  if (_seqbufptr)
  {
    int size;
    size = write (seqfd, _seqbuf, _seqbufptr);
    if (size == -1 && errno == EAGAIN)
    {
      dprintf(("write /dev/sequencer: EAGAIN\n"));
      return;
    }

    if (size < 0)
    {
      perror("write /dev/sequencer");
      exit(-1);
    }

    _seqbufptr -= size;
    if (_seqbufptr)
    {
      memmove(_seqbuf, _seqbuf + size, _seqbufptr);
      dprintf(("write /dev/sequencer: queue full!\n"));
    }
  }
}


/*
 * timer interrupt. reads all events from the seqfd and
 * echoes them back.
 */

void TimerInter(int dummy)
{
  unsigned char buf[128];
  int size;
  putchar('.'); fflush(stdout);
  while ((size = read(seqfd, buf, sizeof(buf))) > 0)
  {
    int i = 0;
    while (i < size)
    {
      if (buf[i] == EV_CHN_COMMON || buf[i] == EV_CHN_VOICE)
      {
        if (ioctl(seqfd, SNDCTL_SEQ_OUTOFBAND, &buf[i]) < 0)
           perror("ioctl outofband");
      }
      i += 8;
    }
  }

  /* catch the next signal too */
  signal(SIGALRM, TimerInter);
}




int main(int argc, char **argv)
{
  int time_base = 120;
  int tempo     = 120;
  struct itimerval it, ot;

  if (argc != 2)
  {
    puts("argument is the midi device no (the output from showdev)");
    return 1;
  }

  /* open device in non blocking mode */

  seqfd = open(SEQUENCER_DEVICE, O_RDWR | O_NDELAY);
  if (seqfd < 0)
  {
    perror(SEQUENCER_DEVICE);
    return 1;
  }

  /* start recording */

  ioctl(seqfd, SNDCTL_SEQ_RESET, 0);
  ioctl(seqfd, SNDCTL_TMR_TIMEBASE, &time_base);
  ioctl(seqfd, SNDCTL_TMR_TEMPO, &tempo);

  SEQ_START_TIMER();
  seqbuf_dump();

  /* start the polling timer */

  it.it_interval.tv_sec = 0;
  it.it_interval.tv_usec = 500 * 1000;
  it.it_value = it.it_interval;
  setitimer(ITIMER_REAL, &it, &ot);
  signal(SIGALRM, TimerInter);

  /* event loop */

  puts("now you should hear what you play on your midi keybord (play slow!)");
  puts("press ^C to stop");
  getchar();

  /* no cleanup .. */
  return 0;
}


