/*
**  The JAZZ++ Midi Sequencer
**
** Copyright (C) 1994-2000 Andreas Voss and Per Sigmond, all rights reserved.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/                                                                              

#include "wx.h"
#pragma hdrstop

#include "toolbar.h"


#ifdef wx_msw

tToolBar::tToolBar(wxFrame *frame, tToolDef *td, int n)
  //toolRibbon = new TestRibbon(frame, 0, 0, 100, 30, 0, wxVERTICAL, 1);
  : wxButtonBar(frame, 0, 0, 100, 30, 0, wxVERTICAL, 1)
{
  win = frame;
  int i;

  SetMargins(5, 5);
#if !WIN95
  GetDC()->SetBackground(wxLIGHT_GREY_BRUSH);
#endif

  for (i = 0; i < n; i++)
  {
    wxBitmap *bitmap = new wxBitmap((char *)td->resid);
    AddTool(td->id, bitmap, NULL, td->sticky, -1, -1, NULL, (char *)td->tooltip);
    if (td->sep)
      AddSeparator();
    td ++;
  }
#if WIN95
  CreateTools();
#endif
}


#else // unix


tToolBar::tToolBar(wxFrame *frame, tToolDef *td, int n)
  : wxToolBar(frame, 0, 0, -1, -1, wxTB_3DBUTTONS, wxHORIZONTAL, n)
{
  win = frame;
  int i;

  SetMargins(5, 5);

  int width = 24;
  int currentX = 5;
  for (i = 0; i < n; i++)
  {
    wxBitmap *bitmap = new wxBitmap((char **)td->resid, NULL);
    AddTool(td->id, bitmap, NULL, td->sticky, (float)currentX, -1, NULL);
    if (td->sep)
      currentX += 12;
    currentX += width;
    td ++;
  }
}

#endif


Bool tToolBar::OnLeftClick(int toolIndex, Bool toggled)
{
  win->OnMenuCommand(toolIndex);
  return TRUE;
}

void tToolBar::OnMouseEnter(int toolIndex)
{
}

