/////////////////////////////////////////////////////////////////////////////
//
// Machine dependend audio object
//
// Time-stamp: <97/02/27 15:31:37 vels>
// Copyright (c) Vladimir Lobak, VDO Corp.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _MACHINE_AUDIO_H_
#define _MACHINE_AUDIO_H_

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

#ifdef IRIX
#include <dmedia/audio.h>
#endif

#ifdef SOLARIS
#include <sys/audioio.h>

#include <fcntl.h>
#include <sys/types.h>
#include <sys/file.h>
#include <stropts.h>

#define	DEFAULT_AUDIODEV	    "/dev/audio"
#endif

#ifdef LINUX
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <linux/soundcard.h>

#define AUDIODEV "/dev/audio"
#endif


class AudioDevice
{                              
public:
  AudioDevice(int sampleSize=8, int samplesPerSec=8000, int channels=1);
  ~AudioDevice();

  int samplesPerSec() { return m_samplesPerSec; }
  int bytesPerSec()   { return m_samplesPerSec * m_s2b; }
  int sampleSize()    { return m_sampleSize; }
  int channels()      { return m_channels; } 

  enum { AUDIO_READ      = O_RDONLY, 
         AUDIO_WRITE     = O_WRONLY, 
         AUDIO_READWRITE = O_RDWR };

  // Open and initialize audio device
  int  open(int mode);

  // Close audio device
  void close();

  // Flush all data queued for reading/writing
  void flush();

  // Complete any data transfers that are in progress
  void sync();

  // Get/Set output audio volume
  int  speakerGain();
  void setSpeakerGain(int value);

  // Space available for write in audio buffer (in samples)
  int  fillable();

  // Amount of data available for read (in samples)
  int  available();                      

  // Play samples
  int  write(char *buffer, int numSamples);

  // Read audio samples
  int  read(char *buffer, int maxSamples);

#if (defined SOLARIS) || (defined LINUX)
  int audioFd() { return m_audioFd; }
#endif

private:
  int m_sampleSize;
  int m_samplesPerSec;
  int m_channels;

  int m_isReadable;
  int m_isWritable;

#ifdef IRIX
  ALport   m_port;
  ALconfig m_config;
#endif

#if (defined SOLARIS) || (defined LINUX)
  int      m_audioFd;
  int      m_bytesPerSec;
  int      m_s2b;
#endif

};

#endif
