#ifndef MainDlg_included
#define MainDlg_included

#include <qdialog.h>
#include <qsocknot.h>

#include "MainDlgData.h"
#include "../server/defs.h"

class MainDlg : public QDialog, public MainDlgData
{
  Q_OBJECT;

public:
  MainDlg(QWidget* parent = NULL, const char* name = NULL);

  int  ConnectToServer();
  void DisconnectFromServer();
  void InitiateSend();

public slots:
  void OnSetup();
  void OnRetreive();
  void OnSend();
  void OnSockRead(int fd);
  void OnItemSelect(int index);

  // -- HACK --
  void OnServerErrorMsg();
  void OnMailData();
  // -- HACK --

private:
  QString         m_serverName, m_userName;
  int             m_port;
  int             m_sock;
  QSocketNotifier *m_sockNotifier;

  enum            { WF_NONE, 
                    WF_WELCOME, 
                    WF_USEROK, 
                    WF_RCPTOK, 
                    WF_LIST, 
                    WF_MAILDATA, 
                    WF_DELOK, 
                    WF_SENDOK };
  enum            { RETREIVE,
                    SEND };
  int             m_waitFor, m_state;
  QString         m_sendMsg;
  int             m_connectedBy;
  char            m_tempFile[PATH_MAX+1];

  // -- HACK --
  char            *m_lastServerErrorMsg;
  int             m_receivedIndx;
  char            *m_receivedMail;
  int             m_receivedMailSize;
  // -- HACK --
};
#endif // MainDlg_included
