#include <qmsgbox.h>
#include "qPlayDlg.h"

#define SIZE 160

PlayDlg::PlayDlg(char *buf, int size, QWidget* parent, const char *name) :
  QDialog(parent, name, TRUE),
  PlayDlgData(this)
{
  // Initialize state
  m_isPlaying  = FALSE;
  m_buf        = buf;
  m_size       = size;

  m_gsmHandle  = NULL;
  m_audio      = NULL;

  // GUI logic
  connect(m_delBtn, SIGNAL(clicked()), this, SLOT(accept()));
  connect(m_playBtn, SIGNAL(clicked()), this, SLOT(OnPlay()));
  connect(m_backBtn, SIGNAL(clicked()), this, SLOT(reject()));
}


PlayDlg::~PlayDlg()
{
  free(m_buf);
}

void PlayDlg::cleanup()
{
#ifdef USE_GSM
  // Close GSM handle
  if (m_gsmHandle)
  {
    gsm_destroy(m_gsmHandle);
    m_gsmHandle = NULL;
  }
#endif

  // Stop reading from temporary file
  if (m_timer)
  {
    m_timer->stop();
    delete m_timer;
    m_timer = NULL;
  }

  if (m_audio)
  {
    delete m_audio;
    m_audio = NULL;
  }
}

#define SIZE 160
void PlayDlg::OnPlay()
{
  // Stop playing
  if (m_isPlaying)
  {
    // Enable buttons
    m_playBtn->setText("Play audio mail");
    m_delBtn->setEnabled(TRUE);
    m_backBtn->setEnabled(TRUE);

    cleanup();
    
    m_isPlaying = FALSE;
  }
  else // Start playing
  {
    // Open audio device and create GSM handle
    m_audio = new AudioDevice(16, 8000, 1);
    if (m_audio->open(AudioDevice::AUDIO_WRITE)
#ifdef USE_GSM
        && (m_gsmHandle = gsm_create()) != NULL
#endif
        )
    {
      // Disable buttons
      m_playBtn->setText("Stop");
      m_delBtn->setEnabled(FALSE);
      m_backBtn->setEnabled(FALSE);
      
      // Initialize counters
      m_isPlaying = TRUE;
      m_bufPos    = 0;
      m_time.start();

      // Start playing audio
      m_timer = new QTimer(this);
      connect(m_timer, SIGNAL(timeout()), this, SLOT(OnAudioPlay()));
      m_timer->start(500 / (m_audio->bytesPerSec()/SIZE) );
    }
    else
    {
      QMessageBox::message("Error", "Unable to open audio device.\n"
                           "Or initialize GSM compression.");
    }
  }
}

void PlayDlg::OnAudioPlay()
{
#ifdef USE_GSM
  gsm_signal sample[SIZE];
  gsm_frame  buf;
#else
  char       sample[SIZE];
  char       buf[SIZE];
#endif

  // Get next frame from buffer
  memcpy((char *)buf, m_buf+m_bufPos, sizeof(buf));

#ifdef USE_GSM
  // Decompress with GSM
  if (gsm_decode(m_gsmHandle, buf, sample) < 0)
  {
    cleanup();
    QMessageBox::message("Error", "Error decompressing audio !");
    reject();
    return;
  }
#else
  memcpy(sample, buf, SIZE);
#endif

  // And write it to audio device
  if (m_audio->write((char *)sample, SIZE) != SIZE)
  {
    cleanup();
    QMessageBox::message("Error", "Can't to write to audio device.");
    reject();
    return;
  }
  
  m_bufPos += sizeof(buf);

  // End of buffer
  if (m_bufPos == m_size)
  {
    cleanup();
    
    // Enable buttons
    m_playBtn->setText("Listen");
    m_delBtn->setEnabled(TRUE);
    m_backBtn->setEnabled(TRUE);
    
    m_isPlaying = FALSE;
    
    return;
  }

  // Number of seconds elapsed
  QString secStr;
  secStr.setNum(m_time.elapsed()/1000);

  // Change label
  m_secLbl->setText(secStr + " secs");
}
