#ifndef PlayDlg_included
#define PlayDlg_included

#include <qdialog.h>
#include <qdatetm.h>
#include <qtimer.h>

#include "PlayDlgData.h"
#include "machine_audio.h"
extern "C" {
#include "gsm.h"
}

class PlayDlg : public QDialog,	private PlayDlgData
{
  Q_OBJECT
    
public:
  PlayDlg(char *buf, int size, 
          QWidget* parent = NULL,  const char *name = NULL);
  virtual ~PlayDlg();

public slots:
  void OnPlay();
  void OnAudioPlay();

private:
  void cleanup();

private:
  int          m_isPlaying;
  char         *m_buf;
  int          m_size;
  int          m_bufPos;

  gsm          m_gsmHandle;
  AudioDevice  *m_audio;
  QTimer       *m_timer;
  QTime        m_time;
};
#endif // PlayDlg_included
