#ifndef RecDlg_included
#define RecDlg_included

#include <qdialog.h>
#include <qdatetm.h>
#include <qsocknot.h>
#include <qtimer.h>

#include "RecDlgData.h"
#include "machine_audio.h"
extern "C" {
#include "gsm.h"
}

class RecDlg : public QDialog, public RecDlgData
{
  Q_OBJECT;

public:
  RecDlg(QWidget* parent = NULL, const char* name = NULL);
  ~RecDlg();
  const char *tempFile() { return (const char *)m_tempFileName; }
  const char *rcpt()     { return m_recipientLine->text(); }
  const char *subject()  { return m_subjLine->text(); }

public slots:
  void OnRecord();
  void OnPlay();
  void OnSend();
  void OnAudioRead(int fd);
  void OnTempFileRead();

private:
  void cleanup();

private:
  int              m_isRecording, m_isRecordered, m_isPlaying;

  int              m_tempFile;
  QString          m_tempFileName;

  AudioDevice      *m_audio;
  int              m_bytesRecordered;
  QSocketNotifier  *m_sockNotifier;
  QTimer           *m_timer;
  QTime            m_time;
  gsm              m_gsmHandle;
};
#endif // RecDlg_included
