#ifndef SetupDlg_included
#define SetupDlg_included

#include <qdialog.h>
#include "SetupDlgData.h"

class SetupDlg : public QDialog, public SetupDlgData
{
  Q_OBJECT;

public:
  SetupDlg(QWidget* parent = NULL, const char* name = NULL);

  const char *serverName() { return m_serverLine->text(); }
  const char *userName() { return m_userLine->text(); }
  int port() { return QString(m_portLine->text()).toInt(); }

  void setServerName(QString s) { m_serverLine->setText(s); }
  void setUserName(QString s) { m_userLine->setText(s); }
  void setPort(int port)
  {
    QString portStr;
    portStr.setNum(port);
    m_portLine->setText(portStr);
  }
};
#endif // SetupDlg_included
