#include <stdlib.h>

#include "defs.h"
#include "server.h"
#include "util.h"

int OnConnected(int sock);

main(int argc, char *argv[])
{
  sockaddr_in addr;
  int addrLen;
  int sock;

  // Parse arguments
  if (argc < 2)
  {
    printf("Usage: %s server [port]\n", argv[0]);
    return 0;
  }

  // Parse host name
  if (!FillAddr(argv[1], (argc > 2) ? atoi(argv[2]) : LISTEN_PORT, &addr))
    return -1;

  // Create tcp socket
  if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0)
  {
    perror("socket");
    return -1;
  }

  // Connect
  if (connect(sock, (sockaddr *)&addr, sizeof(sockaddr_in)) < 0)
  {
    perror("connect");
    return -1;
  }

  // Connected ! Start talking
  printf("Connected to %s...\n", inet_ntoa(addr.sin_addr));
  return OnConnected(sock);
}
