#include "defs.h"
#include "client.h"
#include "util.h"

/////////////////////////////////////////////////////////////////////////////
// Talk to server
int OnConnected(int sock)
{
  fd_set readBitmask;
  char s[MAX_STRLEN+1], *p=s;

  // Work
  while (1)
  {
    // Wait for server message or user input
    FD_ZERO(&readBitmask);
    FD_SET(sock, &readBitmask);
    FD_SET(STDIN_FILENO, &readBitmask);
    if (select(sock+1, &readBitmask, NULL, NULL, NULL) < 0)
    {
      perror("select(read)");
      return -1;
    }

    // Read server message
    if (FD_ISSET(sock, &readBitmask))
    {
      int size;
      char *buf;
      if ((buf=RecvMsg(sock, &size)) == NULL)
        return -1;
      
      // Show it to user
      printf("%s", buf);
      free(buf);
    }
    
    // Read console input
    if (FD_ISSET(STDIN_FILENO, &readBitmask))
    {
      // Read next character
      if (read(STDIN_FILENO, p, 1) < 0)
      {
        perror("read(stdin)");
        return -1;
      }

      // End of command ?
      if (*p == '\n')
      {
        // Send to server
        *p = 0;
        int len = (int)(p-s)+1;
        if (len > 1)
        {
          if (SendMsg(sock, s, len) < 0)
            return -1;
        }
        p = s;
      }
      else
      {
        if ((int)(p-s) == MAX_STRLEN)
        {
          fprintf(stderr, 
                  "Input shouldn't be longer that %d characters ! (ignored)\n",
                  MAX_STRLEN);
        }
        else
        {
          p++;
        }
      }
    } // reading user input
  }

  return 0;
}
