#ifndef _SERVER_H_
#define _SERVER_H_

#include "defs.h"

#define LISTEN_PORT  9009
#define MAX_MSGSIZE  (1024*1000)

#define DELIMITERS   " \t"

typedef struct _Mail
{
  char fname[PATH_MAX+1];

  unsigned long dataPos;       // Position of mail data in file
  char from[MAX_STRLEN];       // user@host
  char subject[MAX_STRLEN];    // subject
  char date[MAX_STRLEN];       // entered date
  char *data;                  // mail data (GSM)
} Mail;

typedef struct _Action
{
  char *cmd;
  int(*action)(void);
} Action;

// Actions
int  OnHelp();
int  OnUserName();
int  OnList();
int  OnReadMail();
int  OnDelMail();
int  OnSendMail();
int  OnMailData(char *buf, int size);
int  OnQuit();

#endif // _SERVER_H_
