/*
 * $Log: helpers.cpp,v $
 * Revision 1.2  1997/07/08 15:31:00  ral
 * Funktion zum kopieren einer Datei eingefuegt.
 *
 */

#include <stdlib.h>
#include <string.h>
#include "helpers.h"
#include <fstream.h>
#include <unistd.h>

#ifndef rcsid
static char rcsid[]="$Id: helpers.cpp,v 1.2 1997/07/08 15:31:00 ral Exp $";
#endif

char*cstrdup(const char*source)
{
	if (!source)
		return NULL;
	char*string_return;
	string_return = new char[strlen(source)+1];
	if (string_return)
		strcpy(string_return, source);
	return string_return;
}

int copy_datei(const char*source, const char*target)
{
	ifstream s(source,ios::in | ios::nocreate);
	if (!s)
		return -1;
	ofstream d(target,ios::out | ios::trunc);
	if (!d)
		return -1;
	for (char Byte=s.get(); Byte != EOF; Byte=s.get())
		if (!d.put(Byte))
			return -1;
	return 0;
}
int move_file(const char*source, const char*target)
{
   if (copy_datei(source,target) == -1)
     return -1;
   unlink(source);
   return 0;
}
