#include "mainwidget.hh"
#include <qapp.h>
#include <qlayout.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qobjcoll.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qpixmap.h>
#include <qfiledlg.h>
#include <errno.h>
#include "mixer_icon.hh"
#include "helpers.h"
#include "options.hh"
#include "mwidget.hh"
#include <qtooltip.h>

#include <kapp.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <kwm.h>
#include <kconfig.h>

extern KApplication*MainApp;
QToolTipGroup * TipGroup;

#ifndef rcsid
static char rcsid[]="$Id: mainwidget.cpp,v 1.15 1998/08/08 11:31:43 ral Exp $";
#endif

// Constructor of the main widget
// break into more parts next release
MyWidget::MyWidget( )
    : KTopLevelWidget()
{
    // two layouts which take the  elements
    int width_counter = 0;

    KMenuBar* menubar = new KMenuBar(this);    
    KStatusBar*statusbar = new KStatusBar(this);
    CHECK_PTR(menubar);
    CHECK_PTR(statusbar);
    TipGroup = new QToolTipGroup(this);
    CHECK_PTR(TipGroup);

    QPixmap icon;
    icon.loadFromData(mixer_xpm_data,mixer_xpm_len);
    setIcon(icon);
    setIconText("XqMixer");
    setCaption("XWindows Mixer");
    //    KWM::setIcon(winId(),&icon);

    mainmixer = new MixerWidget(this);

    CHECK_PTR(mainmixer);
    setView(mainmixer,FALSE);
    mainmixer->show();

    file = new QPopupMenu;
    CHECK_PTR(file);

    file->insertItem("&Load mixer from file",mainmixer,SLOT(read_mixer()),CTRL+Key_L);
    file->insertItem("&Save mixer to file",mainmixer,SLOT(save_mixer()),CTRL+Key_S);
    file->insertSeparator();
    file->insertItem("E&xit",this,SLOT(raus_hier()),CTRL+Key_Q);

    menubar->insertItem("&File",file);
    opt = new QPopupMenu;
    CHECK_PTR(opt);

    opt->setCheckable(TRUE);
    disp_id = opt->insertItem("ValueDisplays on",this,SLOT(toggle_value_display()),CTRL+Key_D);
    last_act = 0;
    opt->insertSeparator();
    los = opt->insertItem("Load on startup",this,SLOT(load_on_startup()));
    lol = opt->insertItem("Load only Layout",this,SLOT(load_only_layout()));
    lov = opt->insertItem("Load only Values",this,SLOT(load_only_values()));
    opt->insertSeparator();
    soe = opt->insertItem("Save all on exit",this,SLOT(save_on_exit()));
    opt->insertItem("Save Options",this,SLOT(save_opts()));
    int optid = menubar->insertItem("&Options",opt);
    menubar->insertSeparator();
    QString about_string = "XqMixer 1.7 by Rajko \"Alwin\" Albrecht";
    about_string+="\nTU Chemnitz / Germany\n";
    about_string+="e-mail: rajko.albrecht@informatik.tu-chemnitz.de\n";
    about_string+="http: www.tu-chemnitz.de/~ral/progs";
    QPopupMenu*f = kapp->getHelpMenu(true,
				     about_string);
    CHECK_PTR(f);

    menubar->insertItem("&Help",f);

    opt->insertItem("Save Values", mainmixer,SLOT(save_vals()));

    opt->setItemChecked(soe,mainmixer->Options->get_save_on_exit());
    opt->setItemChecked(los,mainmixer->Options->get_load_on_start());
    opt->setItemEnabled(lol,mainmixer->Options->get_load_on_start());
    opt->setItemChecked(lol,mainmixer->Options->get_load_only_layout());
    opt->setItemEnabled(lov,mainmixer->Options->get_load_on_start());

    if (!mainmixer->Options->get_load_only_layout()) 
	opt->setItemChecked(lov,mainmixer->Options->get_load_only_vals());
    else {
	opt->setItemChecked(lov,FALSE);
	mainmixer->Options->set_load_only_vals(0);
    }

    menubar->show();
    setMenu(menubar);
    menubar->enableFloating(TRUE);
    statusbar->insertItem("XqMixer 1.7",1);
    setStatusBar(statusbar);

    connect(TipGroup,SIGNAL(showTip(const char*)),this,SLOT(changeStatusbar(const char*)));
    connect(TipGroup,SIGNAL(removeTip()),this,SLOT(deleteStatusText()));
    
    KConfig * k = kapp->getConfig();
    k->setGroup("common");
    int w,h;
    QString ws,hs;
    ws = k->readEntry("width","0");
    hs = k->readEntry("height","0");
    w = ws.toInt();
    h = hs.toInt();
    
    if (w && h)
      resize(w,h);
    else
      adjustSize();
}

void MyWidget::toggle_value_display()
{
    mainmixer->toggle_value_display(last_act);
    last_act = (last_act)?0:1;
    if (last_act)
	opt->changeItem("ValueDisplays off",disp_id);
    else
	opt->changeItem("ValueDisplays on",disp_id);
}

MyWidget::~MyWidget()
{

}

void MyWidget::save_on_exit()
{
    if (mainmixer->Options->get_save_on_exit()) {
	mainmixer->Options->set_save_on_exit(0);
	opt->setItemChecked(soe,FALSE);
    }
    else {
	mainmixer->Options->set_save_on_exit(1);
	opt->setItemChecked(soe,TRUE);
    }
}

void MyWidget::load_on_startup()
{
    if (mainmixer->Options->get_load_on_start()) {
	mainmixer->Options->set_load_on_start(0);
	opt->setItemChecked(los,FALSE);
	opt->setItemEnabled(lol,FALSE);
	opt->setItemEnabled(lov,FALSE);
    }
    else {
	mainmixer->Options->set_load_on_start(1);
	opt->setItemChecked(los,TRUE);
	opt->setItemEnabled(lol,TRUE);
	opt->setItemEnabled(lov,TRUE);
    }
}

void MyWidget::load_only_layout()
{
    if (mainmixer->Options->get_load_only_layout()) {
	opt->setItemChecked(lol,FALSE);
	mainmixer->Options->set_load_only_layout(0);
    }
    else {
	opt->setItemChecked(lol,TRUE);
	mainmixer->Options->set_load_only_layout(1);
	opt->setItemChecked(lov,FALSE);
	mainmixer->Options->set_load_only_vals(0);
    }
}

void MyWidget::load_only_values()
{
    if (mainmixer->Options->get_load_only_vals()) {
	opt->setItemChecked(lov,FALSE);
	mainmixer->Options->set_load_only_vals(0);
    }
    else {
	opt->setItemChecked(lov,TRUE);
	mainmixer->Options->set_load_only_vals(1);
	opt->setItemChecked(lol,FALSE);
	mainmixer->Options->set_load_only_layout(0);
    }
}

void MyWidget::save_opts()
{
    if (mainmixer && mainmixer->Options)
	mainmixer->Options->save_options();
}

void MyWidget::changeStatusbar(const char*text)
{
    KStatusBar*status = statusBar();
    if (status) {
	status->changeItem(text,1);
    }
}

void MyWidget::deleteStatusText()
{
    KStatusBar*status = statusBar();
    if (status)
	status->changeItem("XqMixer 1.5",1);
}

void MyWidget::raus_hier()
{
    if (mainmixer->Options) {
	if (mainmixer->Options->get_save_on_exit()) {
	    save_opts();
	    mainmixer->save_vals();
	}
	//	delete Options;
    }
    KConfig*k = kapp->getConfig();
    k->setGroup("common");
    int w,h;
    w = width();
    h = height();
    QString s;
    s.setNum(w);
    k->writeEntry("width",s);
    s.setNum(h);
    k->writeEntry("height",s);
    kapp->quit();
}
