/*
  declaration of the mixer - related classes
  this are the only which work direct with the device

  $Log: mixer.hh,v $
  Revision 1.3  1997/10/24 13:38:52  ral
  design of mixer_dev changed

  Revision 1.2  1997/10/22 11:44:32  ral
  typedef of mixer info struct
  depends on the used version of sounddriver

  Revision 1.1  1997/10/20 11:27:52  ral
  Initial revision

  */
#include <sys/soundcard.h>
#include <stdlib.h>
#include <unistd.h>

#ifndef __mixer_h
#define __mixer_h

// this is required 'cause the
// mixerinfo structure is in the new OSS driver
// some larger than in the USS
#ifdef UNIX_SOUND_SYSTEM
struct info_mixer {
    char id[16];
    char name[32];
    int counter;
    int fillers[10];
};
typedef info_mixer minfo;
//typedef struct minfo info_t;
#else
typedef mixer_info minfo;
#endif

//forward declaration
class mixer_dev;

class mixer {
    friend class mixer_dev;
    // our "global" variables
    static int mixer_fd;
    static int devmask;
    static int recmask;
    static int recsrc;
    static int stereodev;
    static char*names[SOUND_MIXER_NRDEVICES];
    static int exclusiv_record;
    static char DevName[51];

public:
    mixer();
    virtual ~mixer();
    int get_mixer_fd(){return mixer_fd;}
    static int open_mixer(const char*devname=NULL);
    static void close_mixer(){if (mixer_fd) close(mixer_fd); mixer_fd = 0;}
    static int get_devmask(){return  devmask;}
    static int get_recmask(){return recmask;}
    static int get_recsrc(){return recsrc;}
    static int get_stereodev(){return stereodev;}
    static int is_valid_dev(int dev);
    int is_exclusiv(){return exclusiv_record;}
    void set_recmask();
    static const char*get_name(){return DevName;}
};

class mixer_dev:public mixer {
    int devnumber;
    int balance;
    int value;
    char*Name;

public:
    void set_balance(int nBalance);
    int get_balance(){return balance;}
    void set_value(int nValue);
    int get_value(){return value;}
    void read_values();
    mixer_dev(int nDev);
    char*get_name(){return Name;}
    int is_stereo(){return (((1<<devnumber) & get_stereodev())?  1 : 0);}
    int is_recordsrc() {return (((1<<devnumber) & get_recmask()) ? 1 : 0);}
    void set_record(int On);
    int get_record() {return (((1<<devnumber) & get_recsrc()) ? 1 : 0);}
};

#endif
