#include <qapp.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qobjcoll.h>
#include <qfiledlg.h>
#include <errno.h>
#include "helpers.h"
#include "options.hh"
#include "mwidget.hh"

#include <kapp.h>

#ifndef rcsid
static char rcsid[]="$Id: mwidget.cpp,v 1.2 1998/08/08 11:32:59 ral Exp $";
#endif

extern KApplication*MainApp;

MixerWidget::MixerWidget(QWidget*parent, const char*name)
    :QWidget(parent,name)
{
    QBoxLayout * Regler = new QBoxLayout(this,QBoxLayout::LeftToRight,0,-1,"Regler");
    IntList = 0;
    QString device, d;

    int width_counter = 0;
    int i = 0, j=0;
    /*    if (MainApp->argc() >  2) {
	for (j = 1; j < MainApp->argc(); j++) {
	    d = MainApp->argv()[j];
	    if (d == "-g") {
		device=MainApp->argv()[j+1];
		i = mixer::open_mixer(device);
		j = MainApp->argc();
	    }
	}
    }
    else {*/
	//open default the mixer device
	i = mixer::open_mixer();
	//    }

    Regler = new QBoxLayout(this,QBoxLayout::LeftToRight,0,1,"Regler");
    CHECK_PTR(Regler);

    Options = new options();
    CHECK_PTR(Options);
    Options->load_options();

    if (i < 1) {
	QString er = "Error open Mixer:\n";
	er += strerror(errno);
	er += "\n";
	er += device;
	QLabel * Fehler = new QLabel(er,this,"error");
	Regler->addWidget(Fehler);
	return;
    }

    IntList = new QList<Mixer>;
    CHECK_PTR(IntList);
    IntList->setAutoDelete(TRUE);
    //stepping the devices
    for (i=0; i < SOUND_MIXER_NRDEVICES;i++) {
	//does it exists?
	if (mixer::is_valid_dev(i)) {
	    mix = new  Mixer(this,0,i);
	    CHECK_PTR(mix);
	    //	    mix->setMinimumSize(40,90);
	    Regler->addWidget(mix,10);
	    IntList->append(mix);
	    if (Options->get_load_on_start() ) {
		mix->readvalues(Options,Options->get_load_only_layout());
		if (!Options->get_load_only_vals()) {
		    if (!Options->get_all_display_on())
			mix->set_last_display();
		}
	    }
	}
    }
    if (Options->get_all_display_on())
	toggle_value_display(0);

    j = IntList->count();
}

MixerWidget::~MixerWidget()
{
    mixer::close_mixer();
    if (IntList)
	delete IntList;
}

void MixerWidget::save_vals()
{
    if (!IntList)
	return;
    for ( mix=IntList->first(); mix != 0; mix=IntList->next() )
	mix->writevalues(Options);        
}

void MixerWidget::save_mixer()
{
    if (!Options || !IntList)
	return;
    QString file = QFileDialog::getSaveFileName(0,"*.mxr");
    if (file.isNull())
	return;
    QString o_file = Options->getfile();
    Options->setfile(file);
    for ( mix=IntList->first(); mix != 0; mix=IntList->next() )
	mix->writevalues(Options);    
    Options->setfile(o_file);
}

void MixerWidget::read_mixer()
{
    if (!Options || !IntList)
	return;
    QString file = QFileDialog::getOpenFileName(0,"*.mxr");
    if (file.isNull())
	return;
    QString o_file = Options->getfile();
    Options->setfile(file);
    for ( mix=IntList->first(); mix != 0; mix=IntList->next() )
	mix->readvalues(Options,0);
    Options->setfile(o_file);
}

void MixerWidget::toggle_value_display(int last_act)
{
    if (!IntList)
	return;
    for ( mix=IntList->first(); mix != 0; mix=IntList->next() ) {
	if (!last_act) 
	    mix->display_on();
	else
	    mix->display_off();
    }
}
