/*
 * $Log: options.cpp,v $
 * Revision 1.3  1997/10/30 16:02:21  ral
 * all functions implemented
 *
 * Revision 1.2  1997/10/29 17:07:13  ral
 * *** empty log message ***
 *
 * Revision 1.1  1997/10/29 15:47:36  ral
 * Initial revision
 *
 */

#ifndef rcsid
static char rcsid[]="$Id: options.cpp,v 1.3 1997/10/30 16:02:21 ral Exp $";
#endif

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include <ctype.h>

#include "options.hh"
#include "profile.h"
#include "helpers.h"

/*
 * if parafile == NULL
 * we will use the default ini-file ($HOME)/.XqMixer.ini)
 */
options::options (const char*parafile)
{
    error = 0;
    if (parafile) {
	file = cstrdup(parafile);
	return;
    }
    file = NULL;
    struct passwd * UserInfo;
    uid_t UserId;
    UserId = geteuid();
    UserInfo = getpwuid(UserId);
    if (UserInfo == NULL) {
	file = cstrdup("could not retrieve user informations");
	error = -1;
        return;
    }
    file = new char[strlen(UserInfo->pw_dir)+10];
    strcpy(file,UserInfo->pw_dir);
    strcat(file,"/.XqMixer");
}

options::~options()
{
    if (file)
	delete[]file;
}

void options::setfile(const char*parafile)
{
    if (file) {
	delete[]file;
	file = NULL;
    }
    // if we want delete our profile-file
    if (!parafile)
	return;
    file = cstrdup(parafile);
}

int options::read_value(const char*section,const char*entry)
{
    if (!file)
	return -1;
    return getProfileInt(section,entry,0,file);
}

int options::write_value(const char*section,const char*entry,int nvalue)
{
    if (!file)
	return -1;
    return writeProfileInt(section,entry,nvalue,file);
}

void options::save_options()
{
    writeProfileInt("global","autosave",save_on_exit,file);
    writeProfileInt("global","Loadonlylayout",load_only_layout,file);
    writeProfileInt("global","StartupDisplay",all_display_on,file);
    writeProfileInt("global","IgnoreSingle",ignore_single_display,file);
    writeProfileInt("global","autoload",load_on_start,file);
    writeProfileInt("global","loadonlyvals",load_only_vals,file);
}

void options::load_options()
{
    save_on_exit = getProfileInt("global","autosave",0,file);
    load_on_start = getProfileInt("global","autoload",0,file);
    load_only_layout = getProfileInt("global","Loadonlylayout",0,file);
    all_display_on = getProfileInt("global","StartupDisplay",0,file);
    ignore_single_display = getProfileInt("global","IgnoreSingle",0,file);
    load_only_vals = getProfileInt("global","loadonlyvals",0,file);
}

