/*
 * $Id: options.hh,v 1.3 1997/10/30 16:01:16 ral Exp $
 */


// this class implements a object to handle with the current paramterfile.
// parameterfile should set from the main routine
// it handles only integervalues

#ifndef __options_hh
#define __options_hh

/* 
 * error == -1 non critical errortext in file
 * error == -2 critical  errortext in file
 * error == 0 no error
 */
class options 
{
    //general
    char*file;
    int error;
    //program-options
    int save_on_exit;
    int all_display_on;
    int load_only_layout;
    int ignore_single_display;
    int load_on_start;
    int load_only_vals;
    
public:
    options(const char*parafile=NULL);
    ~options();
    void setfile(const char*parafile);
    const char * getfile(){return file;}
    int read_value(const char*section,const char*entry);
    int write_value(const char*section,const char*entry,int nvalue);
    int get_save_on_exit(){return save_on_exit;}
    void set_save_on_exit(int nvalue){save_on_exit = nvalue;}
    int get_all_display_on(){return all_display_on;}
    void set_all_display_on(int nvalue){all_display_on = nvalue;}
    int get_load_only_layout(){return load_only_layout;}
    void set_load_only_layout(int nvalue){load_only_layout = nvalue;}
    int get_load_only_vals(){return load_only_vals;}
    void set_load_only_vals(int nvalue){load_only_vals = nvalue;}
    int get_ignore_single_display(){return ignore_single_display;}
    void set_ignore_single_display(int nvalue){ignore_single_display = nvalue;}
    int get_load_on_start(){return load_on_start;}
    void set_load_on_start(int nvalue){load_on_start = nvalue;}
    void save_options();
    void load_options();
};

#endif
