#include "qmixer.hh"
#include "qfont.h"
#include <qtimer.h>
#include "options.hh"
#include <qtooltip.h>
#include <kapp.h>

#ifndef rcsid
static char rcsid[]="$Id: qmixer.cpp,v 1.16 1998/08/08 11:34:01 ral Exp $";
#endif

extern QToolTipGroup*TipGroup;

// the function  for re-scaning the devices
// hope 1 second is enough to do that.... :)
void Mixer::Re_Read()
{
    userchanged = FALSE;
    read_values();
    Volume->setValue(100-get_value());
    if (Display)
	Display->display(get_value());
    if (Balance) {
	Balance->setValue(get_balance());
    }
    if (Record) {
	if (get_record())
	    Record->setChecked(TRUE);
	else
	    Record->setChecked(FALSE);
    }
    userchanged = TRUE;
}

//constructur
Mixer::Mixer(QWidget*parent=0,const char * name=0,int dev = 0)
    :QFrame(parent,name),mixer_dev(dev)
{
    par = parent;
    Display = NULL;
    setFrameStyle(Panel | Raised);
    // the value - bar of the device
    Volume = new QSlider(0,100,
			    1,
			    100-get_value(),
			    QSlider::Vertical,
			    this,"volume");
    CHECK_PTR(Volume);
    Volume->setStyle(WindowsStyle);
    Volume->setBackgroundColor(backgroundColor());
    Volume->move(width()/2-Volume->width()/2,3);
    Volume->setFocusPolicy(QWidget::StrongFocus);
    connect(Volume,SIGNAL(valueChanged(int)),this,SLOT(set_volume(int)));
    QToolTip::add(Volume,"Volume slider",TipGroup,"Change volume of device");
    if (is_stereo()) {
	//setting up the bar for changing the balance
	//of course only required if it is a stereo-device
	Balance = new QSlider(0,100,
			      1,
			      get_balance(),
			      QSlider::Horizontal,
			      this,"balance");
	CHECK_PTR(Balance);
	Balance->setStyle(WindowsStyle);
	Balance->setFocusPolicy(QWidget::StrongFocus);
	Balance->setBackgroundColor(backgroundColor());
	//	Balance->setTickmarks(QSlider::Below);
	connect(Balance,SIGNAL(valueChanged(int)),this,SLOT(balance(int)));
	Balance->move(0,height()-Balance->height());
	QToolTip::add(Balance,"Balance",TipGroup,"Change the balance of the device");
    }
    else
	Balance = NULL;
    // the name of the game ... sorry of the device
    // later we will use pixmaps instead
    
    QString name = get_name();
    Name = name.stripWhiteSpace();
    Name_Label = new QLabel(Name,this,"Label");
    CHECK_PTR(Name_Label);
    Name_Label->setAlignment(AlignCenter);
    Name_Label->setFont( QFont( "Times", 12, QFont::Bold ) );
    if (is_recordsrc()) {
	// the CheckBox for enable / disable recording
	// of course only if it is a recordable device
	Record = new QCheckBox("",this);
	CHECK_PTR(Record);
	Record->move(width()/2,height()-20);
	if (get_record()) 
	    Record->setChecked(TRUE);
	else
	    Record->setChecked(FALSE);
	connect(Record,SIGNAL(clicked()),this,SLOT(setRecord()));
	QToolTip::add(Record,"Toggle record",TipGroup,"Toggle device as record source on / off");
    }
    else 
	Record = NULL;
    internalTimer = new QTimer(this);
    connect(internalTimer,SIGNAL(timeout()),SLOT(timeout()));
    internalTimer->start(1000);
    userchanged = TRUE;
    Menu = new QPopupMenu();
    CHECK_PTR(Menu);
    Menu->setFont(QFont("Helvetica",12,QFont::Bold));
    connect(Menu, SIGNAL(activated(int)),this,SLOT(procMenu(int)));
    Menu->insertItem("Show / Hide Value Display");
    Menu->insertSeparator();
    Menu->insertItem("Flat");
    Menu->insertItem("Minimum");
    Menu->insertItem("Maximum");
    if (Balance) {
	Menu->insertSeparator();
	Menu->insertItem("Center Balance");
	Menu->insertItem("Right off");
	Menu->insertItem("Left off");
    }
}

void Mixer::set_volume(int vol)
{
    //'cause point zero is at top
    if (userchanged == TRUE) {
	internalTimer->stop();
	set_value(100-vol);
	if (Display)
	    Display->display(100-vol);
	internalTimer->start(1000);
    }
}

void Mixer::balance(int bal)
{
    if (userchanged == TRUE) {
	internalTimer->stop();
	set_balance(bal);
	internalTimer->start(1000);
    }
}

void Mixer::resizeEvent( QResizeEvent * )
{
    //setting up geometry of the  widget
    Name_Label->setGeometry(3,8,width()-8,25);
    if (Balance)
	Balance->setGeometry(3,height()-40,width()-6,14);
    if (Record)
	Record->setGeometry(width()/2-5,height()-15,10,10);
    if (!Display) {
	Volume->setGeometry(width()/2-8,33,16,height()-85);
    }
    else {
	if (width() < 51) {
	    Display->setGeometry(3,33,width()-6,width()-6);
	    Volume->setGeometry(width()/2-8,width()+30,16,height()-82-width());
	}
	else {
	    Display->setGeometry( ( (width()-50)/2),33,50,50);
	    Volume->setGeometry(width()/2-8,87,16,height()-139);
	}
    }
}

void Mixer::setRecord()
{
    if (Record->isChecked()) {
	set_record(1);
    }
    else {
	set_record(0);
    }
}

void Mixer::timeout()
{
    Re_Read();
}

void Mixer::mousePressEvent(QMouseEvent*ev)
{
    if (ev->button() == RightButton) {
	//	Menu->popup(ev->pos()+pos()+par->pos());
	Menu->popup(kapp->topWidget()->pos()+ev->pos()+pos());
    }
}

void Mixer::procMenu(int id)
{
    switch (id) {
    case 0:
	if (!Display) {
	    display_on();
	}
	else {
	    display_off();
	}
	break;
    case 2:
	Volume->setValue(50);
	break;
    case 3:
	Volume->setValue(100);
	break;
    case 4:
	Volume->setValue(1);
	Volume->setValue(0);
	break;
    case 6:
	Balance->setValue(50);
	break;
    case 7:
	Balance->setValue(0);
	break;
    case 8:
	Balance->setValue(100);
	break;
    default:
	break;
    }
}

void Mixer::display_on()
{
    if (!Display) {
	Display = new QLCDNumber(3,this);
	CHECK_PTR(Display);
	// we want a own colorset for our display
	QColorGroup dcolgroup(QColor(80,255,0),QColor(0,0,0),QColor(160,160,160),QColor(80,80,80),
			      QColor(80,80,80),QColor(80,80,80),QColor(80,80,80));
	Display->setPalette(QPalette(dcolgroup,dcolgroup,dcolgroup));
	
       	Display->setSegmentStyle(QLCDNumber::Flat);
	Display->display(get_value());
	Display->show();
    }
    resizeEvent(NULL);
}

void Mixer::display_off()
{
    if (Display) {
	Display->hide();
	removeChild(Display);
	delete Display;
	Display = NULL;
    }
    resizeEvent(NULL);
}

void Mixer::writevalues(options*Op)
{
    if (!Op)
	return;
    internalTimer->stop();
    Op->write_value(Name,"Volume",get_value());
    if (Balance) {
	Op->write_value(Name,"Balance",get_balance());
    }
    if (Record) {
	Op->write_value(Name,"Record",get_record());
    }
    Op->write_value(Name,"LastDisplay",(Display?1:0));
    internalTimer->start(1000);
}

void Mixer::readvalues(options*Op,int layoutonly)
{
    if (!layoutonly) {
	read_values();
	Volume->setValue(100-Op->read_value(Name,"Volume"));
	if (Balance) {
	    Balance->setValue(Op->read_value(Name,"Balance"));
	}
	if (Record) {
	    if (Op->read_value(Name,"Record") == 1) {
		set_record(1);
		Record->setChecked(TRUE);
	    }
	    else {
		set_record(0);
		Record->setChecked(FALSE);
	    }
	}
    }
    last_display = Op->read_value(Name,"LastDisplay");
}

void Mixer::set_last_display()
{
    if (Display)
	return;
    if (last_display)
	display_on();
}
