/*
 * The widget class for a single mixer-device
 *
 * $Log: qmixer.hh,v $
 * Revision 1.6  1997/10/30 16:00:04  ral
 * Save / read values to / from file inserted
 *
 * Revision 1.5  1997/10/25 12:58:26  ral
 * *** empty log message ***
 *
 * Revision 1.4  1997/10/24 13:37:46  ral
 * callbacks redesigned
 *
 * Revision 1.3  1997/10/21 22:33:00  ral
 * internalTimer object wide to stop
 * it in user-functions.
 *
 * Revision 1.2  1997/10/20 14:51:32  ral
 * timout() slot inserted
 *
 * Revision 1.1  1997/10/20 11:28:52  ral
 * Initial revision
 *
 */
#include <qwidget.h>
#include <qframe.h>
#include <qlcdnum.h>
#include <qslider.h>
#include <qscrbar.h>
#include <qchkbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qevent.h>
#include <qpopmenu.h>
#include "mixer.hh"

#ifndef __qmixer_h
#define __qmixer_h

class options;

class Mixer:public QFrame,public mixer_dev {
    Q_OBJECT
public:
    Mixer(QWidget*parent=0,const char * name=0,int dev = 0);
    void display_on();
    void display_off();
    void writevalues(options*);
    void readvalues(options*,int);
    void set_last_display();
    
 public slots:
    void Re_Read();
 private slots:
    void set_volume(int vol);
    void balance(int bal);
    void setRecord();
    void timeout();
    void procMenu(int);

 signals:
    void ReRead();
    
private:
    QSlider*Volume;
    QSlider*Balance;
    QLCDNumber*Display;
    QLabel*Name_Label;
    QCheckBox*Record;
    bool userchanged;
    QTimer*internalTimer;
    QPopupMenu*Menu;
    QWidget*par;
    QString Name;
    int last_display;
protected:
   void resizeEvent( QResizeEvent * );
   void mousePressEvent(QMouseEvent*);
};

#endif
