/* mix v1.0 (C)Copyright 1997 by Bjorn Ahlquist/a97bjoah@ida.his.se
 * This is GPL software.
 */

#include <linux/soundcard.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#define MIXS 17

struct volume_type {
	char idc;
	char *name;
	int mask;
	int id;
	unsigned char level[2];
} volume[MIXS]={{'v',"Volume",SOUND_MASK_VOLUME,SOUND_MIXER_VOLUME,0,0},
		{'b',"Bass",SOUND_MASK_BASS,SOUND_MIXER_BASS,0,0},
		{'t',"Treble",SOUND_MASK_TREBLE,SOUND_MIXER_TREBLE,0,0},
		{'s',"Synth",SOUND_MASK_SYNTH,SOUND_MIXER_SYNTH,0,0},
		{'p',"PCM",SOUND_MASK_PCM,SOUND_MIXER_PCM,0,0},
		{'k',"Speaker",SOUND_MASK_SPEAKER,SOUND_MIXER_SPEAKER,0,0},
		{'l',"Line",SOUND_MASK_LINE,SOUND_MIXER_LINE,0,0},
		{'m',"Mic",SOUND_MASK_MIC,SOUND_MIXER_MIC,0,0},
		{'c',"CD",SOUND_MASK_CD,SOUND_MIXER_CD,0,0},
		{'x',"IMix",SOUND_MASK_IMIX,SOUND_MIXER_IMIX,0,0},
		{'a',"AltPCM",SOUND_MASK_ALTPCM,SOUND_MIXER_ALTPCM,0,0},
		{'r',"RecLev",SOUND_MASK_RECLEV,SOUND_MIXER_RECLEV,0,0},
		{'i',"IGain",SOUND_MASK_IGAIN,SOUND_MIXER_IGAIN,0,0},
		{'o',"OGain",SOUND_MASK_OGAIN,SOUND_MIXER_OGAIN,0,0},
		{'1',"Line1",SOUND_MASK_LINE1,SOUND_MIXER_LINE1,0,0},
		{'2',"Line2",SOUND_MASK_LINE2,SOUND_MIXER_LINE2,0,0},
		{'3',"Line3",SOUND_MASK_LINE3,SOUND_MIXER_LINE3,0,0}};

void get_settings(int fd,int mixsup)
{
	int i;
	for(i=0;i<MIXS;i++) if(mixsup&volume[i].mask)
		ioctl(fd,MIXER_READ(volume[i].id),&volume[i].level);
}

void print_settings(int mixsup)
{
	int i;
	printf("               Left  Right\n");
	for(i=0;i<MIXS;i++) if(mixsup&volume[i].mask)
		printf("%7s (%c): %5d%% %5d%%\n",volume[i].name,volume[i].idc,
			volume[i].level[0],volume[i].level[1]);
}

void set_settings(int fd,int mixsup)
{
	int i;
	for(i=0;i<MIXS;i++) if(mixsup&volume[i].mask)
		ioctl(fd,MIXER_WRITE(volume[i].id),&volume[i].level);
}

void usage()
{
	printf("mix v1.0 (C)Copyright 1997 by Bjorn Ahlquist/a97bjoah@ida.his.se\n\n");
	printf("Syntax: mix [<mixer><channel><op><volume>]\n");
	printf("	mixer:   vbtspklmcxario123  mixer to adjust\n");
	printf("	channel: lbr		    left/right or both channels\n");
	printf("	op:      +-=		    add, sub or set volume\n");
	printf("\nTip: Just type 'mix' and look at the output.\n");
	exit(-1);
}

void set_level(struct volume_type *vol,char channel,char op,int new_volume)
{
	switch(channel) {
		case 'b':
			if(op=='=') {
				vol->level[0]=new_volume;
				vol->level[1]=new_volume;
			} else if(op=='+') {
				vol->level[0]+=new_volume;
				vol->level[1]+=new_volume;
				if(vol->level[0]>100) vol->level[0]=100;
				if(vol->level[1]>100) vol->level[1]=100;
			} else if(op=='-') {
				vol->level[0]-=new_volume;
				vol->level[1]-=new_volume;
				if(vol->level[0]>100) vol->level[0]=0;
				if(vol->level[1]>100) vol->level[1]=0;
			} else usage();
			break;
		case 'l':
			if(op=='=') vol->level[0]=new_volume;
			else if(op=='+') {
				vol->level[0]+=new_volume;
				if(vol->level[0]>100) vol->level[0]=100;
			} else if(op=='-') {
				vol->level[0]-=new_volume;
				if(vol->level[0]>100) vol->level[0]=0;
			} else usage();
			break;
		case 'r':
			if(op=='=') vol->level[1]=new_volume;
			else if(op=='+') {
				vol->level[1]+=new_volume;
				if(vol->level[1]>100) vol->level[1]=100;
			} else if(op=='-') {
				vol->level[1]-=new_volume;
				if(vol->level[1]>100) vol->level[1]=0;
			} else usage();
			break;
		default:
			usage();
	}
}

int main(int argc,char **argv)
{
	int mfd,mixsup,i,ok,set;

	if(argc>2) usage();

	if((mfd=open("/dev/mixer",O_RDWR,0))<0) {
		perror("Unable to open /dev/mixer\n");
		exit(-1);
	}
	
	if(ioctl(mfd,SOUND_MIXER_READ_DEVMASK,&mixsup)) {
		perror("Unable to get list of mixer devices\n");
		exit(-1);
	}

	get_settings(mfd,mixsup);
	
	if(argc==2) {
		if(strlen(argv[1])<3) usage();
		ok=0;
		for(i=0;i<MIXS;i++) {
			if(volume[i].idc==argv[1][0]) {
				set_level(&volume[i],argv[1][1],argv[1][2],atoi(&argv[1][3]));
				ok=1;
			}
		}
		if(!ok) usage();
	}

	set_settings(mfd,mixsup);
	get_settings(mfd,mixsup);
	print_settings(mixsup);
	exit(0);
}
