/*
    TkMix v1.2: An X11 audio mixer for OSS.
    Copyright (C) 1996 Mike Welch (mike@tara.demon.co.uk)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/                 

#include <tcl.h>
#include <tk.h>
#include "tkmix.h"

int Tcl_MixAppInit(struct MixerData *mix_dat) 
{
	Tcl_SetVar(mix_dat->interp, "argv", "-name \"tkMix\"", TCL_GLOBAL_ONLY);

	if (Tcl_Init(mix_dat->interp) == TCL_ERROR) {
		fprintf(stderr,"Tcl failed to initialise\n");
		return(TCL_ERROR);
	}

    /* Make interpreter non-interactive so Joe Public can't shag it up*/
    Tcl_SetVar(mix_dat->interp, "tcl_interactive","0",TCL_GLOBAL_ONLY);

	if (Tk_Init(mix_dat->interp) == TCL_ERROR) {
		fprintf(stderr,"Tk failed to initialise\n");
		fprintf(stderr,"%s\n",mix_dat->interp->result);
		return(TCL_ERROR);
	}

	Tcl_StaticPackage(mix_dat->interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);

    if (Mixer_AppInit(mix_dat) == TCL_ERROR) {
		fprintf(stderr,"Mixer_AppInit failed\n");
		return(TCL_ERROR);
    }

	return (TCL_OK);
}
