/*
    TkMix v1.2: An X11 audio mixer for OSS.
    Copyright (C) 1996 Mike Welch (mike@tara.demon.co.uk)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#include <stdlib.h>
#include <tcl.h>
#include <tk.h>
#include <linux/soundcard.h>
#include "tkmix.h"

extern Tk_TimerProc *PollMixer();

int SetLevel(struct MixerData *mix_dat, Tcl_Interp *interp, int argc, char **argv)
{
    int temp;
	if (argc == 5) {
    	temp = (atoi(argv[3]) << 8) | (atoi(argv[2]));
	} else {
    	temp = atoi(argv[2]);
	}
    if (ioctl(mix_dat->mixer_fd, MIXER_WRITE(atoi(argv[1])), &temp) == -1) {
		fprintf(stderr,"Error doing IOCTL in SetLevel\n");
		return(TCL_ERROR);
    }
    return (TCL_OK);
}

int SetRecSrc(struct MixerData *mix_dat , Tcl_Interp *interp, int argc, char **argv)
{
    mix_dat->recsrc =((mix_dat->recsrc) & ~(1 << atoi(argv[1])) | ((atoi(argv[2])) << (atoi(argv[1]))));
    if (ioctl(mix_dat->mixer_fd, SOUND_MIXER_WRITE_RECSRC, &(mix_dat->recsrc)) == -1) {
	fprintf(stderr,"Error doing IOCTL in SetRecSrc\n");
	return(TCL_ERROR);
    }
    return (TCL_OK);
}

int SetMute(struct MixerData *mix_dat , Tcl_Interp *interp, int argc, char **argv)
{
    int temp=atoi(argv[1]);
#ifdef DEBUG
    printf("Mute: %s\n",argv[1]);
#endif
    if (ioctl(mix_dat->mixer_fd, SOUND_MIXER_PRIVATE3, &temp) == -1) {
        fprintf(stderr,"Error doing IOCTL in SetMute\n");
        return(TCL_ERROR);
    }
    return(TCL_OK);
}


int SetLoud(struct MixerData *mix_dat , Tcl_Interp *interp, int argc, char **argv)
{
    int temp = atoi(argv[1]);
#ifdef DEBUG
    printf("Loud: %s\n",argv[1]);
#endif
    if (ioctl(mix_dat->mixer_fd, SOUND_MIXER_PRIVATE1, &temp) == -1) {
        fprintf(stderr,"Error doing IOCTL in SetLoud\n");
        return(TCL_ERROR);
    }
    return(TCL_OK);
}

int SetEnhance(struct MixerData *mix_dat , Tcl_Interp *interp, int argc, char **argv)
{
   int temp = atoi(&argv[1][0]);

#ifdef DEBUG
    printf("Enhance: %d\n",temp);
#endif
    if (ioctl(mix_dat->mixer_fd, SOUND_MIXER_PRIVATE2, &temp) == -1) {
        fprintf(stderr,"Error doing IOCTL in SetEnhance\n");
        return(TCL_ERROR);
    }
    return(TCL_OK);
}

int Mixer_AppInit(struct MixerData *mix_dat)
{
    Tcl_CreateCommand(mix_dat->interp, "SetRecSrc", (Tcl_CmdProc *)SetRecSrc,
                     mix_dat, (void (*)()) NULL);
    Tcl_CreateCommand(mix_dat->interp, "SetLevel", (Tcl_CmdProc *)SetLevel,
                     mix_dat, (void (*)()) NULL);
    Tcl_CreateCommand(mix_dat->interp, "SetLoud", (Tcl_CmdProc *)SetLoud,
                     mix_dat, (void (*)()) NULL);
    Tcl_CreateCommand(mix_dat->interp, "SetMute", (Tcl_CmdProc *)SetMute,
                     mix_dat, (void (*)()) NULL);
    Tcl_CreateCommand(mix_dat->interp, "SetEnhance", (Tcl_CmdProc *)SetEnhance,
                     mix_dat, (void (*)()) NULL);

    return (TCL_OK);
}
