/*
    TkMix v1.2: An X11 audio mixer for OSS.
    Copyright (C) 1996 Mike Welch (mike@tara.demon.co.uk)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

#include <string.h>
#include <linux/soundcard.h>
#include <tcl.h>
#include "tkmix.h"

int BuildTclScript(struct MixerData *mix_dat,struct Tcl_DString *dstring)
{
    register int i,j;
    int lablen,start,end;
    char buffer[200];
    char *devnames[SOUND_MIXER_NRDEVICES] = SOUND_DEVICE_LABELS;
    

    sprintf(buffer, "frame .top\n");
    Tcl_DStringAppend(dstring, buffer,-1);

	if (mix_dat->flags & TKM_VOLUME_ONLY) {
		start=end=SOUND_MIXER_VOLUME;
	} else {
    	start=0;
    	end=SOUND_MIXER_NRDEVICES;
	}

    for(i=start;i<=end;i++) {
		if((1 << i) & mix_dat->devmask) {
		    sprintf(buffer, "frame .top.levframe%d -relief groove -borderwidth 4\n" ,i);
		    Tcl_DStringAppend(dstring, buffer,-1);
		    if ((1 << i) & mix_dat->recmask) {
		    	sprintf(buffer, "checkbutton .top.levframe%d.recbut%d -selectcolor Green -command \"SetRecSrc %d \\$recbut%d\"\n" ,i,i,i,i);
		    	Tcl_DStringAppend(dstring, buffer,-1);
		    } else {
		    	sprintf(buffer, "checkbutton .top.levframe%d.recbut%d -state disabled -disabledforeground \"\"\n" ,i,i);
		    	Tcl_DStringAppend(dstring, buffer,-1);
		    }
		    sprintf(buffer, "pack .top.levframe%d.recbut%d\n" ,i,i);
		    Tcl_DStringAppend(dstring, buffer,-1);

	    	if ((1 << i) & mix_dat->stereodevs) {
	    		sprintf(buffer, "frame .top.levframe%d.topframe\n",i);
	    		Tcl_DStringAppend(dstring, buffer,-1);
	    		sprintf(buffer, "scale .top.levframe%d.topframe.levell -from 100 -to 0 -variable level%dl -label \"\" -showvalue 0 -command \"SetLevel %d \\$level%dl \\$level%dr\"\n",i,i,i,i,i);
	    		Tcl_DStringAppend(dstring, buffer,-1);
	    		sprintf(buffer, "scale .top.levframe%d.topframe.levelr -from 100 -to 0 -variable level%dr -label \"\" -showvalue 0 -command \"SetLevel %d \\$level%dl \\$level%dr\"\n",i,i,i,i,i);
	    		Tcl_DStringAppend(dstring, buffer,-1);
	
		    	sprintf(buffer, "pack .top.levframe%d.topframe.levell -side left -fill y\n",i);
    	    	Tcl_DStringAppend(dstring, buffer,-1);
		    	sprintf(buffer, "pack .top.levframe%d.topframe.levelr  -side right -fill y\n",i);
    	    	Tcl_DStringAppend(dstring, buffer,-1);
		    	sprintf(buffer, "pack .top.levframe%d.topframe -expand 1 -fill y\n",i);
    	    	Tcl_DStringAppend(dstring, buffer,-1);
		    } else {
		    	sprintf(buffer, "scale .top.levframe%d.levelm -from 100 -to 0 -variable level%dm -label \"\" -showvalue 0 -command \"SetLevel %d \\$level%dm\"\n",i,i,i,i);
		    	Tcl_DStringAppend(dstring, buffer,-1);
		    	sprintf(buffer, "pack .top.levframe%d.levelm -expand 1 -fill y\n",i);
    	    	Tcl_DStringAppend(dstring, buffer,-1);

		    }

		    /* This is a hack to retain centering of the device labels */
		    /* whilst working around a missing label bug someone reported to me*/
		    if (devnames[i][0]==' ') {
		    	sprintf(devnames[i],"\"\"");
			}
		    sprintf(buffer, "label .top.levframe%d.label -text %s\n", i,devnames[i]);
		    Tcl_DStringAppend(dstring, buffer,-1);
		    sprintf(buffer, "pack .top.levframe%d.label -side bottom\n",i);
    	    Tcl_DStringAppend(dstring, buffer,-1);
		    sprintf(buffer, "pack .top.levframe%d -side left -expand 1 -fill both -pady 4 -padx 2\n",i);
    	    Tcl_DStringAppend(dstring, buffer,-1);
		}
    }

	if (!(mix_dat->flags & TKM_VOLUME_ONLY)) {
	    /*Draw widgets for Loudness, Mute and Enhance*/
	    if (mix_dat->flags & (TKM_MUTE | TKM_LOUDNESS | TKM_ENHANCE)) {
	    	sprintf(buffer, "frame .bottom\n");
	    	Tcl_DStringAppend(dstring, buffer,-1);
		}
	
	   	if(mix_dat->flags & TKM_MUTE) {
	   		sprintf(buffer, "frame .bottom.mute -relief groove -borderwidth 4\n" );
			Tcl_DStringAppend(dstring, buffer,-1);
		 	sprintf(buffer, "checkbutton .bottom.mute.mbutton -text \"Mute\" -command \"SetMute \\$mbutton\"\n" );
	 		Tcl_DStringAppend(dstring, buffer,-1);
	   		sprintf(buffer, "pack .bottom.mute .bottom.mute.mbutton -side right -fill both -expand 1 -padx 2 -pady 2\n");
	   		Tcl_DStringAppend(dstring, buffer,-1);
	   	}
	
	    if(mix_dat->flags & TKM_LOUDNESS) {
	    	sprintf(buffer, "frame .bottom.loud -relief groove -borderwidth 4\n" );
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    	sprintf(buffer, "checkbutton .bottom.loud.lbutton -text \"Loudness\" -command \"SetLoud \\$lbutton\"\n" );
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    	sprintf(buffer, "pack .bottom.loud .bottom.loud.lbutton -side right -fill both -expand 1 -padx 2 -pady 2\n");
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    }
	
	    if(mix_dat->flags & TKM_ENHANCE) {
	    	sprintf(buffer, "frame .bottom.enhance -relief groove -borderwidth 4\n" );
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    	sprintf(buffer, "label .bottom.enhance.label -text \"Stereo Field Enhancement\"\npack .bottom.enhance.label\n" );
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    	sprintf(buffer, "foreach button {None 40%% 60%% 80%%} {\n set lower [string tolower $button]\n");
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    	sprintf(buffer, "radiobutton .bottom.enhance.$lower -variable enhance -value $button -text $button -command \"SetEnhance \\$enhance\"\n" );
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    	sprintf(buffer, "pack .bottom.enhance.$lower -side left -fill both -expand 1 }\n" );
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    	sprintf(buffer, "pack .bottom.enhance -side right -fill both -expand 1 -padx 2 -pady 2\n");
	    	Tcl_DStringAppend(dstring, buffer,-1);
	    }
	}
	
    if ((mix_dat->flags & (TKM_MUTE | TKM_LOUDNESS | TKM_ENHANCE)) && !(mix_dat->flags & TKM_VOLUME_ONLY)) {
	    sprintf(buffer, "pack .top .bottom -expand 1 -fill both\n");
	} else {
	    sprintf(buffer, "pack .top -expand 1 -fill both\n");
	}
	
    Tcl_DStringAppend(dstring, buffer,-1);
}
