/*
    xfmix - audio mixer
    Copyright (C) 1995  Radek Doulik

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <forms.h>
#include "light.h"

#define ST (*(int*)ob->spec)
#define WI (*((int*)(ob->spec)+1))
#define RE (*((int*)(ob->spec)+2))

int fl_get_lightbox(FL_OBJECT *ob) {
  return ST;
}

void fl_set_lightbox(FL_OBJECT *ob, int n) {
  if (n!=ST) {
    ST=(n) ? 1 : 0;
    fl_redraw_object(ob);
  }
}

void fl_set_lightbox_width(FL_OBJECT *ob, int w) {
  WI=w;
}

void fl_set_lightbox_response(FL_OBJECT *ob, int r) {
  RE=r;
}

static int handle_lightbox(FL_OBJECT *ob, int event, FL_Coord x, FL_Coord y,
			   int n, void *v) {
  int xp=(ob->align==FL_ALIGN_LEFT) ? ob->x : ob->x+ob->w-1-WI;

  switch (event) {
  case FL_DRAW:
    fl_drw_frame(ob->boxtype, xp, ob->y, WI, ob->h, ob->col1, ob->bw);
    fl_drw_box(FL_FLAT_BOX, xp, ob->y, WI, ob->h, (ST) ? ob->col2 : ob->col1, 0);

/*    fl_drw_text(ob->align, ob->x+ob->h+1, ob->y, ob->w, ob->h,
		ob->lcol, ob->lsize, ob->lstyle, ob->label); */
    
    if (ob->align==FL_ALIGN_LEFT) {
      fl_drw_text(ob->align, ob->x+WI+1, ob->y, ob->w, ob->h,
		  ob->lcol, ob->lsize, ob->lstyle, ob->label);
    } else {
      fl_drw_text(ob->align, ob->x, ob->y, ob->w-WI, ob->h,
		  ob->lcol, ob->lsize, ob->lstyle, ob->label);
    }
    
    break;

#define XEV ((XButtonEvent*)xev)

  case FL_PUSH:
    if (!RE) break;
    fl_drw_box(FL_FLAT_BOX, xp, ob->y, WI, ob->h, (ST) ? ob->col1 : ob->col2, 0);

    break;
  case FL_SHORTCUT:
  case FL_RELEASE:
    if (!RE) break;
    ST=1-ST;
    fl_drw_box(FL_FLAT_BOX, xp, ob->y, WI, ob->h, (ST) ? ob->col2 : ob->col1, 0);

    return 1;

#undef XEV
  }

  return 0;
}

FL_OBJECT* fl_create_lightbox(int type, FL_Coord x, FL_Coord y, 
			      FL_Coord w, FL_Coord h, char *name) {

  FL_OBJECT* ob=fl_make_object(FL_LIGHTBOX, type, x, y, w, h, "", handle_lightbox);

  ob->boxtype=FL_DOWN_BOX;
  ob->pushed=0;
  ob->col2=FL_YELLOW;
  ob->label=name;
  ob->align=FL_ALIGN_LEFT;
  ob->spec=(void*)fl_malloc(3*sizeof(int));
  ST=0;
  WI=h;
  RE=1;

  return ob;
}


FL_OBJECT* fl_add_lightbox(int type, FL_Coord x, FL_Coord y, 
			   FL_Coord w, FL_Coord h, char *name) {

  FL_OBJECT* ob=fl_create_lightbox(type, x, y, w, h, name);

  fl_add_object(fl_current_form, ob);

  return ob;
}
