/*
 *   xmmix - Motif(tm) Audio Mixer
 *
 *   Copyright (C) 1995  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __WIDGET_H__
#define __WIDGET_H__

#ifndef LINT
static char *_widget_h_ident_ = "@(#)widget.h	2.2 95/05/11";
#endif


#define CHSET1		"chset1"
#define CHSET2		"chset2"
#define CHSET3		"chset3"

#define NENHANCE	4		/* Number of enhance stereo settings */

#define CTL_INPUT	1		/* Control types */
#define CTL_OUTPUT	2
#define CTL_MISC	3

/* Slider info structure */
typedef struct {
	Widget		widget_lbl;		/* Slider label widget */
	Widget		widget_lbl_l;		/* Slider left label widget */
	Widget		widget_lbl_r;		/* Slider right label widget */
	Widget		widget_l;		/* Left slider widget */
	Widget		widget_r;		/* Right slider widget */
	Widget		widget_lock_btn;	/* Lock button widget */
	Widget		widget_rec_btn;		/* Rec button widget */
	char		*label;			/* Label string */
	char		*name;			/* Base name */
	int		type;			/* Control type */
	int		order;			/* Display order */
	bool_t		supp;			/* Slider supported */
	bool_t		recsupp;		/* Rec button supported */
} slinfo_t;

/* Pulldown menu support structures */
typedef struct {
	Widget		widget;			/* Pushbutton widget */
	char		*label;			/* Label string */
	char		*name;			/* Button name */
	char		*acc;			/* Accelerator */
	char		*mne;			/* Mnemonic */
} btinfo_t;

typedef struct {
	Widget		widget;			/* Cascade button widget */
	char		*label;			/* Label string */
	char		*name;			/* Button name */
	char		*acc;			/* Accelerator */
	char		*mne;			/* Mnemonic */
	btinfo_t	*btip;			/* Array of btinfo_t structs */
} pdinfo_t;

/* Holder for all widgets */
typedef struct {
	/* Top-level */
	Widget		toplevel;		/* Toplevel shell widget */
	Widget		logolbl;		/* Logo label */

	/* Main window widgets */
	Widget		form;			/* Form container */
	Widget		menu_bar;		/* Menu bar */
	Widget		file_mnu;		/* File pulldown menu */
	Widget		options_mnu;		/* Options pulldown menu */
	Widget		help_mnu;		/* Help pulldown menu */
	Widget		hsep;			/* Horizontal separator */
	Widget		flat_btn;		/* Flat button */
	Widget		mute_btn;		/* Mute button */
	Widget		loud_btn;		/* Loudness button */
	Widget		enh_opt;		/* Enhance option menu */
	Widget		enh_mnu;		/* Enhance option pulldown */
	Widget		enh_btn[NENHANCE];	/* Enhance option buttons */
	bool_t		mute_supp;		/* Mute supported */
	bool_t		loud_supp;		/* Loudness supported */
	bool_t		enh_supp;		/* Enhance supported */
	slinfo_t	*sl;			/* Slider information */
	pdinfo_t	*file_pd;		/* File menu information */
	pdinfo_t	*opts_pd;		/* Options menu information */
	pdinfo_t	*help_pd;		/* Help menu information */

	/* File selection box popup widgets */
	Widget		fsform;			/* Form container */
	Widget		fsbox;			/* File selection box */

	/* Help window widgets */
	Widget		helpform;		/* Form container */
	Widget		helptxt;		/* Help text widget */
	Widget		helpsep;		/* Separator */
	Widget		helpok_btn;		/* Help OK button */

	/* Popup dialog boxes */
	Widget		about;			/* About dialog box */
	Widget		warning;		/* Warning dialog box */
} widgets_t;


/* Public function prototypes */
extern void	widget_init(widgets_t *);
extern void	create_widgets(widgets_t *);
extern void	post_realize_config(widgets_t *);
extern void	register_callbacks(widgets_t *);

#endif /* __WIDGET_H__ */

