.\"
.\"	$Id: cddaplay.man,v 1.3 2000/12/20 20:57:31 solyga Exp $
.\"
.TH [%s PRG_NAME] [%d MANUAL_NUMBER] "[%s DATE_OF_LAST_MOD]" "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"
.SH NAME
[%s prg_name] \- play back cdda file
.SH SYNOPSIS
.B [%s prg_name]
.RB [ -hvVx ]
.RB [ -D
.IR dsp_device ]
.RB [ -F
.IR fr ]
.RB [ -S
.IR speed ]
.RI [ file ]

.SH DESCRIPTION
.I [%s Prg_name]
plays back a cdda file (44.1kHz/16bit/stereo linear encoded raw pcm sound
file with big-endian byte order) on the local dsp device which defaults to
.IR [%s DEFAULT_DSP_DEVICE] .

.SH OPTIONS
.TP
.B -h
display some helpful information on
.I [%s HELP_CHANNEL_STR]
and exit successfully
.TP
.B -v
raise verbosity level on [%s VERBOSE_CHANNEL_STR]
.TP
.B -V
display version and compilation info on
.I [%s VERSION_CHANNEL_STR]
and exit successfully
.TP
.B -x
swap byte order
.TP
.BI "\-F " fr
play specified frames only (default 0 - EOF); say "f0" for playing frames
f0 to EOF, "f0-f1" for playing frames f0 to (excluding) f1 or "f0+df" for
playing frames f0 to (excluding) f0+df
.TP
.BI "\-S " speed
set sample speed to
.I speed
Hz which must be between [%d MIN_DSP_SPEED] and [%d MAX_DSP_SPEED]
(default [%d DEFAULT_DSP_SPEED])

.SH RETURN VALUE
On success, [%d RETVAL_OK] is returned. On error, a value >0 is returned.

.SH ERRORS
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR cddack (1),
.BR cddagen (1),
.BR cddamod (1),
.BR cddaproc (1),
.BR cddaread (1),
.BR cddarec (1)
