/*
    GSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998,99 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include "about_dialog.h"
#include "setup_dialog.h"
#include "version.h"

#include "pixmaps/gsrnd.xpm"


static GtkWidget *gsrnd_about_dialog = (GtkWidget *)NULL;


void gsrnd_about_dialog_destroy (GtkWidget *widget, gpointer *data)
{
	gtk_widget_destroy(gsrnd_about_dialog);
	gsrnd_about_dialog = NULL;
}


void gsrnd_about_dialog_create (void)
{
	static char *messages[8] = {
		"Surround Sound control panel for The Gimp Toolkit.\n",
		"This program is free software and is distributed under the terms",
		"of the GNU General Public License.\n",
		"* 3D-Phonic is a registered trademark of",
		"  VICTOR COMPANY OF JAPAN, LIMITED.",
		"* DOLBY, the double-D symbol and PRO LOGIC are trademarks of",
		"  Dolby Laboratories Licensing Corporation.",
		"* miro is a registered trademark of miro Computer Products AG."
	};
	int i;
	GtkWidget *hbox, *vbox;
	GtkStyle *style;
	GdkPixmap *pixmap;
	GtkWidget *pixmapwid;
	GdkBitmap *mask;
	GtkWidget *label;
	GtkWidget *button;
	char buffer[80], version[10];


	if (!gsrnd_about_dialog) {
		gsrnd_about_dialog = gtk_dialog_new();
		gtk_window_set_wmclass(GTK_WINDOW(gsrnd_about_dialog), "about_dialog", "GSrnd");
		gtk_window_set_title(GTK_WINDOW(gsrnd_about_dialog), "About GSrnd");
		gtk_signal_connect(GTK_OBJECT(gsrnd_about_dialog), "destroy", (GtkSignalFunc)gsrnd_about_dialog_destroy, NULL);
		gtk_widget_realize(gsrnd_about_dialog);

		hbox = gtk_hbox_new(FALSE, 0);
		style = gtk_widget_get_style(gsrnd_about_dialog);
		pixmap = gdk_pixmap_create_from_xpm_d(gsrnd_about_dialog->window, &mask, &style->bg[GTK_STATE_NORMAL], (gchar**)gsrnd_xpm);
		pixmapwid = gtk_pixmap_new(pixmap, mask);
		gtk_box_pack_start(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, 10);
		gtk_widget_show(pixmapwid);

		vbox = gtk_vbox_new(FALSE, 0);
		gsrnd_setup_get_version(version);
		sprintf(buffer, "GSrnd %.2f (SRND driver %s)", APP_VERSION, version);
		label = gtk_label_new(buffer);
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
		label = gtk_label_new("Copyright  1998,99 Oliver Gantz (o.gantz@tu-bs.de).");
		gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
		gtk_widget_show(label);
		gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 10);
		gtk_widget_show(vbox);

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_about_dialog)->vbox), hbox, TRUE, TRUE, 10);
		gtk_widget_show(hbox);

		hbox = gtk_hbox_new(FALSE, 0);
		vbox = gtk_vbox_new(FALSE, 0);
		for (i=0; i < 8; i++) {
			label = gtk_label_new(messages[i]);
			gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
			gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
			gtk_widget_show(label);
		}
		gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 10);
		gtk_widget_show(vbox);

		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_about_dialog)->vbox), hbox, TRUE, TRUE, 10);
		gtk_widget_show(hbox);

		gtk_widget_show(GTK_DIALOG(gsrnd_about_dialog)->vbox);
	
		button = gtk_button_new_with_label("OK");
		gtk_signal_connect_object(GTK_OBJECT(button), "clicked", (GtkSignalFunc)gsrnd_about_dialog_destroy, NULL);
		gtk_widget_set_usize(button, 80, 0);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(gsrnd_about_dialog)->action_area), button, FALSE, FALSE, 10);
		gtk_widget_show(button);
		gtk_widget_show(GTK_DIALOG(gsrnd_about_dialog)->action_area);
	}
	
	if (!GTK_WIDGET_VISIBLE(gsrnd_about_dialog))
		gtk_widget_show(gsrnd_about_dialog);
	else
		gdk_window_raise(gsrnd_about_dialog->window);
}
