/*
    GSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998,99 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include "main_widget.h"
#include "preferences_dialog.h"
#include "setup_dialog.h"
#include "message_dialog.h"
#include "resources.h"



GtkTooltips *gsrnd_tooltips;


int main (int argc, char *argv[])
{
	static GdkColor color = { 0, 61669, 59113, 35979 };
	GdkColormap *colormap;
	GtkWidget *window;
	GtkWidget *main_widget;

	gtk_init (&argc, &argv);

	gsrnd_tooltips = gtk_tooltips_new();

	rc_load(".gsrndrc");
	gsrnd_load_preferences();
	gsrnd_main_load_preferences();
	gsrnd_setup_load_preferences();
	if ((srnd_fd = open(gsrnd_preferences.device, O_RDWR)) == -1) {
		gsrnd_message_dialog_create("Could not open SRND device.\n%s", strerror(errno));
	} else
		fcntl(srnd_fd, F_SETFD, 1);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_wmclass(GTK_WINDOW(window), "main_dialog", "GSrnd");
	gtk_window_set_title(GTK_WINDOW(window), "Surround Control");
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gsrnd_main_quit), NULL);

	gtk_widget_realize(window);
	colormap = gdk_window_get_colormap(window->window);
	gdk_color_alloc(colormap, &color);
	gtk_tooltips_set_colors(gsrnd_tooltips, &color, &window->style->fg[GTK_STATE_NORMAL]);

	main_widget = gsrnd_main_widget_new(window);
	gtk_container_add(GTK_CONTAINER(window), main_widget);
	gtk_widget_show(main_widget);

	gtk_widget_show(window);

	gtk_main();

	return 0;
}
