/*
    GSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998,99 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include "main_widget.h"
#include "about_dialog.h"
#include "preferences_dialog.h"
#include "setup_dialog.h"
#include "resources.h"

#include "pixmaps/dolbypro.xpm"


extern GtkTooltips *gsrnd_tooltips;


GSrndMainPreferences gsrnd_main_preferences;


static GtkWidget *mode_widget;
static GtkObject *volume_object;
static GtkWidget *bypass_widget;



void gsrnd_main_load_preferences (void)
{
	rc_set_group("Main");
	gsrnd_main_preferences.mode = rc_read_int("Mode", 0);
	gsrnd_main_preferences.volume = rc_read_int("Volume", 100);
	gsrnd_main_preferences.bypass = rc_read_bool("Bypass", FALSE);
}


void gsrnd_main_save_preferences (void)
{
	rc_set_group("Main");
	rc_write_int("Mode", gsrnd_main_preferences.mode);
	rc_write_int("Volume", gsrnd_main_preferences.volume);
	rc_write_bool("Bypass", gsrnd_main_preferences.bypass);
	rc_save();
}


void gsrnd_main_set_defaults (void)
{
	gtk_option_menu_set_history(GTK_OPTION_MENU(mode_widget), gsrnd_main_preferences.mode);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(volume_object), (gfloat)gsrnd_main_preferences.volume * 0.1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bypass_widget), gsrnd_main_preferences.bypass);

	gsrnd_setup_set_mode(gsrnd_main_preferences.mode);
	gsrnd_setup_set_volume((int)((double)gsrnd_main_preferences.volume * 0.16 + 0.5));
	gsrnd_setup_set_bypass(gsrnd_main_preferences.bypass);
}


void gsrnd_main_quit (GtkWidget *widget, gpointer *data)
{
	if (gsrnd_preferences.savesettings)
		gsrnd_main_save_preferences();
	gtk_main_quit();
}


void mixer_cmd_callback (GtkWidget *widget, gpointer *data)
{
	if (fork() == 0) {
		execlp(gsrnd_preferences.mixer, gsrnd_preferences.mixer, 0);
		exit(1);
	}
}


void preferences_dialog_cmd_callback (GtkWidget *widget, gpointer *data)
{
	gsrnd_preferences_dialog_create();
}


void setup_dialog_cmd_callback (GtkWidget *widget, gpointer *data)
{
	gsrnd_setup_dialog_create();
}


void about_dialog_cmd_callback (GtkWidget *widget, gpointer *data)
{
	gsrnd_about_dialog_create();
}

	
GtkWidget *gsrnd_menu_bar_new (GtkAccelGroup **accel_group)
{
	GtkWidget *menu, *submenu;
	GtkWidget *menu_bar;
	GtkWidget *menu_item;

	menu_bar = gtk_menu_bar_new();
	*accel_group = gtk_accel_group_new();

	menu = gtk_menu_item_new_with_label("File");
	gtk_widget_show(menu);

	submenu = gtk_menu_new();

	menu_item = gtk_menu_item_new_with_label("Quit");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(gsrnd_main_quit), NULL);
	gtk_menu_append(GTK_MENU(submenu), menu_item);
	gtk_widget_show(menu_item);
	gtk_accel_group_add(*accel_group, 'Q', GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE, GTK_OBJECT(menu_item), "activate");
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu), submenu);
	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu);

	menu = gtk_menu_item_new_with_label("Options");
	gtk_widget_show(menu);

	submenu = gtk_menu_new();

	menu_item = gtk_menu_item_new_with_label("Mixer");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(mixer_cmd_callback), NULL);
	gtk_menu_append(GTK_MENU(submenu), menu_item);
	gtk_widget_show(menu_item);
	menu_item = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(submenu), menu_item);
	gtk_widget_show(menu_item);
	menu_item = gtk_menu_item_new_with_label("Preferences...");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(preferences_dialog_cmd_callback), NULL);
	gtk_menu_append(GTK_MENU(submenu), menu_item);
	gtk_widget_show(menu_item);
	menu_item = gtk_menu_item_new_with_label("Mode Settings...");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(setup_dialog_cmd_callback), NULL);
	gtk_menu_append(GTK_MENU(submenu), menu_item);
	gtk_widget_show(menu_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu), submenu);

	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu);


	menu = gtk_menu_item_new_with_label("Help");
	gtk_menu_item_right_justify(GTK_MENU_ITEM(menu));
	gtk_widget_show(menu);

	submenu = gtk_menu_new();

	menu_item = gtk_menu_item_new_with_label("About...");
	gtk_signal_connect(GTK_OBJECT(menu_item), "activate", GTK_SIGNAL_FUNC(about_dialog_cmd_callback), NULL);
	gtk_menu_append(GTK_MENU(submenu), menu_item);
	gtk_widget_show(menu_item);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu), submenu);

	gtk_menu_bar_append(GTK_MENU_BAR(menu_bar), menu);

	return menu_bar;
}


void main_mode_callback (GtkWidget *widget, gpointer data)
{
	gsrnd_main_preferences.mode = (int)data;
	gsrnd_setup_set_mode(gsrnd_main_preferences.mode);
}

void main_volume_callback (GtkAdjustment *adjustment, gpointer data)
{
	static int last_value = -1;

	gsrnd_main_preferences.volume = (int)(adjustment->value * 10.0 + 0.5);
	if (gsrnd_main_preferences.volume != last_value) {
		gsrnd_setup_set_volume((int)((double)gsrnd_main_preferences.volume * 0.16 + 0.5));
		last_value = gsrnd_main_preferences.volume;
	}

}

void main_bypass_callback (GtkWidget *widget, gpointer data)
{
	gsrnd_main_preferences.bypass = GTK_TOGGLE_BUTTON(widget)->active;
	gsrnd_setup_set_bypass(gsrnd_main_preferences.bypass);
}


GtkWidget *gsrnd_main_widget_new (GtkWidget *parent)
{
	GtkWidget *vbox, *hbox;
	GtkWidget *menu_bar;
	GtkWidget *label;
	GtkWidget *volume;
	GtkWidget *menu, *item;
	GtkWidget *pixmapwid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	GtkStyle *style;
	GtkAccelGroup *accel_group;

	gtk_widget_realize(parent);

	vbox = gtk_vbox_new(FALSE, 0);

	menu_bar = gsrnd_menu_bar_new(&accel_group);
	gtk_window_add_accel_group(GTK_WINDOW(parent), accel_group);
	gtk_box_pack_start(GTK_BOX(vbox), menu_bar, FALSE, FALSE, 0);
	gtk_widget_show(menu_bar);

	hbox = gtk_hbox_new(FALSE, 10);

	label = gtk_label_new("Mode");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 10);
	gtk_widget_show(label);

	menu = gtk_menu_new();
	item = gtk_menu_item_new_with_label("Dolby Pro Logic");
	gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(main_mode_callback), (gpointer)0);
	gtk_container_add(GTK_CONTAINER(menu), item);
	gtk_widget_show(item);
	item = gtk_menu_item_new_with_label("3D-Phonic");
	gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(main_mode_callback), (gpointer)1);
	gtk_container_add(GTK_CONTAINER(menu), item);
	gtk_widget_show(item);
	item = gtk_menu_item_new_with_label("Through Stereo");
	gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(main_mode_callback), (gpointer)2);
	gtk_container_add(GTK_CONTAINER(menu), item);
	gtk_widget_show(item);
	item = gtk_menu_item_new_with_label("Noise Generator");
	gtk_signal_connect(GTK_OBJECT(item), "activate", GTK_SIGNAL_FUNC(main_mode_callback), (gpointer)3);
	gtk_container_add(GTK_CONTAINER(menu), item);
	gtk_widget_show(item);
	mode_widget = gtk_option_menu_new();
	gtk_option_menu_set_menu(GTK_OPTION_MENU(mode_widget), menu);
	gtk_box_pack_end(GTK_BOX(hbox), mode_widget, FALSE, FALSE, 10);
	gtk_widget_show(mode_widget);
	gtk_tooltips_set_tip(gsrnd_tooltips, mode_widget, "Surround Mode", "");
	
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 6);
	
	gtk_widget_show(hbox);

	hbox = gtk_hbox_new(FALSE, 0);

	volume_object = gtk_adjustment_new(0.0, 0.0, 10.0, 1.0, 1.0, 0.0);
	gtk_signal_connect(volume_object, "value_changed", GTK_SIGNAL_FUNC(main_volume_callback), NULL);
	
	volume = gtk_hscale_new(GTK_ADJUSTMENT(volume_object));
	gtk_box_pack_start(GTK_BOX(hbox), volume, TRUE, TRUE, 10);
	gtk_widget_show(volume);
	gtk_tooltips_set_tip(gsrnd_tooltips, volume, "Master Volume", "");

	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 2);

	gtk_widget_show(hbox);

	hbox = gtk_hbox_new(FALSE, 0);

	bypass_widget = gtk_check_button_new_with_label("Bypass");
	gtk_signal_connect(GTK_OBJECT(bypass_widget), "clicked", GTK_SIGNAL_FUNC(main_bypass_callback), NULL);
	gtk_box_pack_start(GTK_BOX(hbox), bypass_widget, FALSE, FALSE, 10);
	gtk_widget_show(bypass_widget);
	gtk_tooltips_set_tip(gsrnd_tooltips, bypass_widget, "Bypass Sound", "");

	style = gtk_widget_get_style(parent);
	pixmap = gdk_pixmap_create_from_xpm_d(parent->window, &mask, &style->bg[GTK_STATE_NORMAL], (gchar **)dolbypro_xpm);
	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_box_pack_end(GTK_BOX(hbox), pixmapwid, FALSE, FALSE, 10);
	gtk_widget_show(pixmapwid);

	gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, FALSE, 6);

	gtk_widget_show(hbox);

	gsrnd_main_set_defaults();

	return vbox;
}
